package com.elitesland.scp.application.facade.vo.cart;

import com.alibaba.fastjson.annotation.JSONField;
import com.elitesland.scp.utils.SysUtils;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/26 16:58
 * @Description:
 */
@Data
@ApiModel("采购车详情结果")
public class CartDetailRespVO implements Serializable {

    @ApiModelProperty("商品SPU编码")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty("商品SPU编码")
    private String spuCode;

    @ApiModelProperty("商品SPU名称")
    private String spuName;

    @ApiModelProperty(value = "商品别名")
    private String anotherName;

    @ApiModelProperty("是否收藏，是：true, 否：false")
    private Boolean collectFlag;

    private List<ItemSpecObjectVO> itemSpecObjectVOS;

    @ApiModelProperty("组合商品标识")
    private Boolean combineItemFlag;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;

    @ApiModelProperty(value = "组合数量")
    private BigDecimal combineQty;

    private List<CartDetailRespVO> subItemList;

    @Data
    public static class ItemSpecObjectVO {

        @ApiModelProperty("单位")
        private String uom;

        @ApiModelProperty("单位名称")
        private String uomName;

        @ApiModelProperty("商品规格ID(SKU-ID)")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long itemId;

        @ApiModelProperty("商品规格编码(SKU编码)")
        private String itemCode;

        @ApiModelProperty("商品规格名称(SKU名称)")
        private String itemName;

        @ApiModelProperty("含税单价")
        private BigDecimal itemPrice;

        @ApiModelProperty("数量")
        private BigDecimal qty;

        @ApiModelProperty("库存数量")
        private BigDecimal avalQty;

        @ApiModelProperty("选中状态 0-未选中 1-选中")
        private Integer status;

        @ApiModelProperty("基本单位")
        private String uom2;
        @ApiModelProperty(value = "基本单位名称")
        private String uom2Name;

        @ApiModelProperty("单位转换系数")
        private BigDecimal uomRatio;

        @ApiModelProperty("有效位数")
        private Integer decimalPlaces;

        @ApiModelProperty(value = "商品分类")
        private String itemType;

        @ApiModelProperty(value = "包装规格")
        private String itemAttrName;

        @ApiModelProperty(value = "最小起订量")
        private BigDecimal moq;

        @ApiModelProperty(value = "组合数量")
        private BigDecimal combineQty;


        public BigDecimal getTotalAmt() {
            BigDecimal price = this.itemPrice == null ? BigDecimal.ZERO : this.itemPrice;
            return SysUtils.processAmtScale(price.multiply(this.qty));
        }
    }

    @ApiModelProperty("选中状态 0-未选中 1-选中，当子项全部为1是此值为1，否则为0")
    private Integer status;

    @ApiModelProperty("spu规格型号")
    private String spec;

    @ApiModelProperty("图片url")
    private String url;

    private String fileCode;

    @ApiModelProperty("金额小计")
    private BigDecimal totalAmt;

    @ApiModelProperty("是否在订货周期")
    private Boolean inOrderCycle;
}
