package com.elitesland.scp.application.facade.vo.scpsman;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 17:40
 * @Description:
 */
@Data
@ApiModel(description = "计划员信息保存参数")
public class SalesmanInfoSaveVO implements Serializable {
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("userId")
    private Long userId;

    @ExcelProperty(index = 0)
    @ApiModelProperty("计划员编号")
    @NotBlank(message = "计划员编号不允许为空")
    private String scpsmanNo;

    @ExcelProperty(index = 1)
    @ApiModelProperty("计划员类型")
//    @NotBlank(message = "计划员类型不允许为空")
    private String scpsmanType;

    @ExcelProperty(index = 2)
    @ApiModelProperty("管辖区域")
    private List<String> jurisdictions;

    @ApiModelProperty("上级领导ID")
    private Long leaderUserId;

    @ExcelProperty(index = 17)
    @ApiModelProperty("上级领导编码")
    private String leaderUserCode;

    @ApiModelProperty("上级计划员名称")
    private String masSalesmanName;

    @ExcelProperty(index = 7)
    @ApiModelProperty("登录账号")
    private String loginAccount;

    @ExcelProperty(index = 3)
    @ApiModelProperty(value = "姓名", required = true)
    @NotNull(message = "姓名不允许为空")
    private String name;

    @ExcelProperty(index = 4)
    @ApiModelProperty("手机号")
//    @NotBlank(message = "手机号不允许为空")
    private String phone;

    @ExcelProperty(index = 8)
    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("性别")
    private Integer sex;

    @ExcelProperty(index = 9)
    @ApiModelProperty("性别名称")
    private String sexName;

    @ExcelProperty(index = 10)
    @ApiModelProperty("出生日期")
    private String birthdayTime;

    @ExcelProperty(index = 11)
    @ApiModelProperty("身份证号")
    private String idCardNo;

    @ExcelProperty(index = 12)
    @ApiModelProperty("省")
    private String province;

    @ExcelProperty(index = 13)
    @ApiModelProperty("市")
    private String city;

    @ExcelProperty(index = 14)
    @ApiModelProperty("区")
    private String area;

    @ExcelProperty(index = 15)
    @ApiModelProperty("详细地址")
    private String detailedAddress;

    @ExcelProperty(index = 16)
    @ApiModelProperty("入职日期")
    private String joinTime;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ExcelProperty(index = 5)
    @ApiModelProperty("公司编码")
    @NotBlank(message = "公司编码不允许为空")
    private String ouCode;

    @ApiModelProperty("组织名称")
    private String buName;

    @ExcelProperty(index = 6)
    @ApiModelProperty("组织编码")
    private String buCode;

    @ApiModelProperty("组织id")
    @NotNull(message = "组织id不允许为空")
    private Long buId;

    @ApiModelProperty("启用状态")
    private Integer enableStatus;

    @ApiModelProperty("公司id")
    private String ouId;

    @ApiModelProperty("公司所属组织id")
    private String orgIdBelong;


    @ApiModelProperty("ADD:新增计划员，EMP：绑定现有员工")
    private String source;

    @ApiModelProperty("企业微信用户ID")
    private String outerKey;

    @ApiModelProperty("来源门店编码")
    private String sourceStoreCode;
}
