package com.elitesland.scp.application.service.app;

import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppRelateOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpOrderPayRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSubmitVO;

import java.math.BigDecimal;
import java.util.List;

public interface AppDemandOrderService {

    /**
     * 移动端订货订单提交
     *
     * @param saveVO
     * @return
     */
    long submit(ScpDemandOrderSubmitVO saveVO);

    /**
     * 移动端批量保存
     *
     * @param saveVOS
     */
    void batchSaveDemandOrderD(List<ScpDemandOrderDSaveVO> saveVOS);

    /**
     * 再来一单
     *
     * @param id
     */
    void addCart(Long id);

    /**
     * 详情查询
     *
     * @param id
     * @return
     */
    ScpDemandOrderRespVO findDemandOrderById(Long id);

    /**
     * 查询支付订单详情
     *
     * @param srcDocId
     * @return
     */
    AppPayOrderRespVO findPayOrderById(Long srcDocId);

    /**
     * 查询支付订单详情明细
     *
     * @param srcDocId
     * @return
     */
    AppPayOrderItemRespVO findPayOrderItemById(Long srcDocId);

    /**
     * 查询订货单关联订单信息
     *
     * @param id
     * @return
     */
    List<AppRelateOrderRespVO> findRelateOrderById(Long id);

    /**
     * 查询支付明细信息
     *
     * @param docCls
     * @param id
     * @return
     */
    ScpOrderPayRespVO payInfo(String docCls, Long id);

    /**
     * 补充运费
     */
    void fillFreightOrder();

    /**
     * 计算门店订货金额
     * @param storeId
     * @return
     */
    BigDecimal calculateSaleAmt(Long storeId,String storeCode);
}
