package com.elitesland.scp.application.web.msg.applet;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.query.msg.CommonPublishedMessagePageQueryVO;
import com.elitesland.scp.application.facade.vo.resp.msg.CommonPublishedScpMessagePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.msg.CommonPublishedScpMessageRespVO;
import com.elitesland.scp.common.ScpMessageReceiverType;
import com.elitesland.scp.domain.service.msg.ScpMessageQueryService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/29
 */
@Api(tags = "运营消息-小程序")
@RestController
@RequestMapping(value = "/applet/scpMessage", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class ScpMessageAppletController {

    @Autowired
    private ScpMessageQueryService queryService;

    @ApiOperation(value = "统计门店未读的数量")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParam(name = "storeCode", value = "门店编码", required = true)
    @GetMapping(value = "/store/countUnView")
    public ApiResult<Long> countUnView(@RequestParam(value = "storeCode") @NotBlank(message = "门店编码为空") String storeCode) {
        return queryService.countUnView(ScpMessageReceiverType.STORE, storeCode);
    }

    @ApiOperation(value = "分页查询门店的消息")
    @ApiOperationSupport(order = 2)
    @PostMapping(value = "/store/page")
    public ApiResult<PagingVO<CommonPublishedScpMessagePageRespVO>> pageMng(@RequestBody CommonPublishedMessagePageQueryVO queryVO) {
        return queryService.pagePublished(ScpMessageReceiverType.STORE, queryVO);
    }

    @ApiOperation(value = "查看门店消息详情")
    @ApiOperationSupport(order = 3)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "消息ID", dataType = "long", required = true),
            @ApiImplicitParam(name = "storeCode", value = "门店编码", dataType = "string", required = true),
    })
    @GetMapping(value = "/store/view")
    public ApiResult<CommonPublishedScpMessageRespVO> view(@RequestParam(name = "id") @NotNull(message = "消息ID为空") Long id,
                                                           @RequestParam(value = "storeCode") @NotBlank(message = "门店编码为空") String storeCode) {
        return queryService.viewPublished(id, ScpMessageReceiverType.STORE, storeCode);
    }
}
