package com.elitesland.scp.common;

import com.elitescloud.boot.task.delay.common.DelayTaskSender;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPayTimeoutMqParam;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

@Component
@Slf4j
@AllArgsConstructor
public class OrderStatusCountdownService {

    private final DelayTaskSender delayTaskSender;

    /**
     * 启动倒计时任务
     *
     * @param orderId      订单ID
     * @param delaySeconds 延迟秒数
     * @param targetStatus 目标状态
     */
    public void startCountdown(Long orderId, long delaySeconds, String targetStatus, LocalDateTime startTime) {
        try {
            //写入mq队列,进行收货确认
            ScpDemandOrderPayTimeoutMqParam orderSubmitMqParam = new ScpDemandOrderPayTimeoutMqParam();
            orderSubmitMqParam.setDocId(orderId);
            orderSubmitMqParam.setTargetStatus(targetStatus);
            orderSubmitMqParam.setBusinessKey(ScpDemandOrderPayTimeoutMqParam.SCP_ORDER_PAY_TIMEOUT_CHANNEL);
            // 通过当前时间加上delaySeconds的秒数计算具体时间
            LocalDateTime delayTime = startTime.plusSeconds(delaySeconds);
            log.info("订单 {} 倒计时开始，倒计时结束时间：{}", orderId, delayTime);
            delayTaskSender.send(ScpDemandOrderPayTimeoutMqParam.SCP_ORDER_PAY_TIMEOUT_CHANNEL, orderId.toString(), orderSubmitMqParam, delayTime);
        } catch (Exception e) {
            log.info("启动支付倒计时：{},发送mq消息失败：{}", orderId, e.toString());
        }
        log.info("订单 {} 启动倒计时，{} 秒后更新状态为 {}", orderId, delaySeconds, targetStatus);
    }
}



