package com.elitesland.scp.infr.dto.setting;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("单据类型配置分页返回")
public class ScpOrderSettingDTO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -3038925240131174177L;

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("商品分类")
    private String itemCate;

    @ApiModelProperty("商品分类")
    private List<String> itemCates;

    @ApiModelProperty("采购场景")
    private String purScene;

    @ApiModelProperty("调拨订单单据类型")
    @SysCode(sys = "yst-inv", mod = "TRO_DOC_TYPE")
    private String trnType;
    private String trnTypeName;

    @ApiModelProperty("第一优先级")
    @SysCode(sys = "yst-suplan", mod = "ORDER_PRIORITY")
    private String firstPriority;
    private String firstPriorityName;

    @ApiModelProperty("第二优先级")
    @SysCode(sys = "yst-suplan", mod = "ORDER_PRIORITY")
    private String secPriority;
    private String secPriorityName;

    @ApiModelProperty("仓网供应关系是否计算运费,0:不计算,1:计算")
    private Boolean whnetFreightFlag;

    @ApiModelProperty("供应商份额分配是否计算运费,0:不计算,1:计算")
    private Boolean suppFreightFlag;

    @ApiModelProperty("是否启用,0:禁用,1:启用")
    private Boolean status;

    @ApiModelProperty("是否满额免运费")
    private Boolean freeFreightFlag;

    @ApiModelProperty("免运费金额")
    private BigDecimal freeFreightAmt;

    @ApiModelProperty("要求到货日期天数")
    private Long demandArriveDays;

}
