package com.elitesland.scp.mq;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.infr.repo.supalloc.ScpSupplyAllocationRepoProc;
import com.elitesland.scp.infr.repo.template.ScpDemandOrderTemplateRepoProc;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepoProc;
import com.elitesland.support.provider.out.ItmItemUpdateMqParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * 门店收货单发货回写
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class ItmItemUpdateListener implements MessageQueueListener<ItmItemUpdateMqParam> {
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final ScpWhNetRelationRepoProc scpWhNetRelationRepoProc;
    private final ScpSupplyAllocationRepoProc scpSupplyAllocationRepoProc;
    private final ScpDemandOrderTemplateRepoProc scpDemandOrderTemplateRepoProc;

    @Override
    public @NotEmpty String[] channels() {
        return new String[]{ItmItemUpdateMqParam.ITEM_UPDATE_CHANNEL};
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onConsume(@NotBlank String s, @NotNull ItmItemUpdateMqParam itmItemUpdateMqParam) {
        log.info("商品变更：" + JSON.toJSONString(itmItemUpdateMqParam));
        Long itemId = itmItemUpdateMqParam.getItemId();
        String itemName = itmItemUpdateMqParam.getItemName();
        scpWhNetRelationRepoProc.updateItemNameByItemId(itemId, itemName);
        scpSupplyAllocationRepoProc.updateItemNameByItemId(itemId, itemName);
        scpDemandOrderTemplateRepoProc.updateItemNameByItemId(itemId, itemName);
        scpCateItemRepoProc.updateItemNameByItemId(itemName,itemId);

    }

}
