package com.elitesland.scp.utils;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.commons.lang.StringUtils;

import java.io.IOException;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 12日 20:00
 * @version: 1.0
 */
public class LocalDateTimeFormatter extends JsonDeserializer<LocalDateTime> {

    public static final String DATE_FORMAT_1 = "yyyy-MM-dd";
    public static final String DATE_FORMAT_2 = "yyyy/MM/dd HH:mm:ss";
    public static final String DATE_FORMAT_3 = "yyyy/MM/dd";
    public static final String DATE_FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_DATETIME_1 = "yyyy-MM-dd H:mm:ss";
    public static final String DATE_FORMAT_DATETIME_2 = "yyyy-MM-dd HH:mm:00";

    public static final String DATE_FORMAT_DATETIME_3 = "yyyy/M/d H:mm:ss";


    private static String[] pattern =
            new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd","yyyy-MM-dd H:mm:ss","yyyy-MM-dd HH:mm:00","yyyy/M/d H:mm:ss"};


    @Override
    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        LocalDateTime targetDate = null;
        String originDate = jsonParser.getText();
        if (StringUtils.isNotEmpty(originDate)) {
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                targetDate = LocalDateTime.parse(originDate, formatter);
            } catch (Exception e) {
                try {
                    targetDate = LocalDateTimeUtil.parse(originDate, DATE_FORMAT_1);
                } catch (Exception r) {

                }
                if (targetDate != null) {
                    return targetDate;
                }
                try {
                    targetDate = LocalDateTimeUtil.parse(originDate,DATE_FORMAT_2);
                } catch (Exception r) {

                }
                if (targetDate != null) {
                    return targetDate;
                }
                try {
                    targetDate = LocalDateTimeUtil.parse(originDate,DATE_FORMAT_3);
                } catch (Exception r) {

                }
                if (targetDate != null) {
                    return targetDate;
                }

                try {
                    targetDate = LocalDateTimeUtil.parse(originDate,DATE_FORMAT_DATETIME);
                } catch (Exception r) {

                }
                if (targetDate != null) {
                    return targetDate;
                }
                try {
                    targetDate = LocalDateTimeUtil.parse(originDate, DATE_FORMAT_DATETIME_1);
                } catch (Exception r) {

                }
                if (targetDate != null) {
                    return targetDate;
                }
                try {
                    targetDate = LocalDateTimeUtil.parse(originDate,DATE_FORMAT_DATETIME_2);
                } catch (Exception r) {

                }
                if (targetDate != null) {
                    return targetDate;
                }
                try {
                    targetDate = LocalDateTimeUtil.parse(originDate,DATE_FORMAT_DATETIME_3);
                } catch (Exception r) {

                }
                if(targetDate == null){
                    throw new IOException(String.format(
                            "'%s' can not convert to type 'java.time.LocalDateTime',just support timestamp(type of long) and following date format(%s)",
                            originDate,
                            StringUtils.join(pattern, ",")));
                }

            }
        }
        return targetDate;
    }


}
