/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.calendar;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLinePageParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLineParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLinePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLineRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetLineDelVO;
import com.elitesland.scp.domain.service.calendar.ScpStoreCalendarSetLineDomainService;
import com.elitesland.scp.infr.repo.calendar.ScpStoreCalendarSetLineRepoProc;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpStoreCalendarSetLineDomainServiceImpl
implements ScpStoreCalendarSetLineDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreCalendarSetLineDomainServiceImpl.class);
    private final ScpStoreCalendarSetLineRepoProc scpStoreCalendarSetLineRepoProc;

    @Override
    public PagingVO<ScpStoreCalendarSetLinePageRespVO> queryCalendarSetLineList(ScpStoreCalendarSetLinePageParamVO paramVO) {
        long count = this.scpStoreCalendarSetLineRepoProc.count(paramVO);
        if (count > 0L) {
            List<ScpStoreCalendarSetLinePageRespVO> demandSet = this.scpStoreCalendarSetLineRepoProc.queryCalendarSetLine(paramVO);
            return new PagingVO(count, demandSet);
        }
        return new PagingVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByParam(ScpStoreCalendarSetLineDelVO paramVO) {
        this.scpStoreCalendarSetLineRepoProc.deleteByParam(paramVO);
    }

    @Override
    public List<ScpStoreCalendarSetLineRespVO> findCalendarSetByParam(Long masId, Integer todayWeek) {
        return this.scpStoreCalendarSetLineRepoProc.findStoreByParam(masId, todayWeek);
    }

    @Override
    public List<ScpStoreCalendarSetLineRespVO> findCalendarSetInfoByParam(ScpStoreCalendarSetLineParamVO paramVO) {
        return this.scpStoreCalendarSetLineRepoProc.findStoreByParam(paramVO);
    }

    @Override
    public Long countCalendarSetLine(ScpStoreCalendarSetLineParamVO paramVO) {
        return this.scpStoreCalendarSetLineRepoProc.countCalendarSetLine(paramVO);
    }

    @Override
    public List<ScpStoreCalendarSetLineRespVO> findStoreCodeByMasId(Long masId, Integer year) {
        return this.scpStoreCalendarSetLineRepoProc.findStoreCodeByMasId(masId, year);
    }

    public ScpStoreCalendarSetLineDomainServiceImpl(ScpStoreCalendarSetLineRepoProc scpStoreCalendarSetLineRepoProc) {
        this.scpStoreCalendarSetLineRepoProc = scpStoreCalendarSetLineRepoProc;
    }
}

