/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.mrp;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpPageParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpRespVO;
import com.elitesland.scp.domain.entity.mrp.QScpMrpDDO;
import com.elitesland.scp.domain.entity.mrp.QScpMrpDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ScpMrpRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QScpMrpDO scpMrpDO = QScpMrpDO.scpMrpDO;
    private final QScpMrpDDO scpMrpDDO = QScpMrpDDO.scpMrpDDO;
    private final QBean<ScpMrpRespVO> baseBean;

    public PagingVO<ScpMrpRespVO> pageQuery(ScpMrpPageParam param) {
        if (param == null) {
            return PagingVO.builder().total(0L).records(null).build();
        }
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.baseBean).from((EntityPath)this.scpMrpDO);
        jpaQuery.where(this.where(param));
        if (CollectionUtil.isNotEmpty(param.getOuIds()) || CollectionUtil.isNotEmpty(param.getWhIds()) || CollectionUtil.isNotEmpty(param.getItemIds())) {
            JPQLQuery<Integer> subQuery = this.getSubQuery(this.scpMrpDO.id.eq(this.scpMrpDDO.masId), param);
            jpaQuery.where((Predicate)subQuery.exists());
        }
        param.setPaging(jpaQuery);
        param.fillOrders(jpaQuery, this.scpMrpDO);
        return PagingVO.builder().total(this.pageCount(param).longValue()).records(jpaQuery.fetch()).build();
    }

    public Long pageCount(ScpMrpPageParam param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.scpMrpDO.count()).from((EntityPath)this.scpMrpDO);
        if (param != null) {
            jpaQuery.where(this.where(param));
            if (CollectionUtil.isNotEmpty(param.getOuIds()) || CollectionUtil.isNotEmpty(param.getWhIds()) || CollectionUtil.isNotEmpty(param.getItemIds())) {
                JPQLQuery<Integer> subQuery = this.getSubQuery(this.scpMrpDO.id.eq(this.scpMrpDDO.masId), param);
                jpaQuery.where((Predicate)subQuery.exists());
            }
        }
        return jpaQuery.fetchCount();
    }

    private JPQLQuery<Integer> getSubQuery(BooleanExpression id, ScpMrpPageParam param) {
        JPQLQuery subQuery = (JPQLQuery)JPAExpressions.selectOne().from(new EntityPath[]{this.scpMrpDDO}).where(new Predicate[]{id});
        if (CollectionUtil.isNotEmpty(param.getOuIds())) {
            subQuery.where(new Predicate[]{this.scpMrpDDO.ouId.in(param.getOuIds())});
        }
        if (CollectionUtil.isNotEmpty(param.getWhIds())) {
            subQuery.where(new Predicate[]{this.scpMrpDDO.whId.in(param.getWhIds())});
        }
        if (CollectionUtil.isNotEmpty(param.getItemIds())) {
            subQuery.where(new Predicate[]{this.scpMrpDDO.itemId.in(param.getItemIds())});
        }
        return subQuery;
    }

    private Predicate where(ScpMrpPageParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StrUtil.isNotBlank((CharSequence)param.getMrpLotNo())) {
            predicates.add(this.scpMrpDO.mrpLotNo.like(param.getMrpLotNo() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getPredLotNo())) {
            predicates.add(this.scpMrpDO.mrpLotNo.like(param.getPredLotNo() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getCalcStatus())) {
            predicates.add(this.scpMrpDO.calcStatus.eq((Object)param.getCalcStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getPushStatus())) {
            predicates.add(this.scpMrpDO.pushStatus.eq((Object)param.getPushStatus()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public void updatePushStatus(List<Long> ids, String pushStatus, String pushFailReason) {
        JPAUpdateClause updateClause = this.jpaQueryFactory.update((EntityPath)this.scpMrpDO).set((Path)this.scpMrpDO.pushStatus, (Object)pushStatus).where(new Predicate[]{this.scpMrpDO.id.in(ids)});
        if (StrUtil.isNotBlank((CharSequence)pushFailReason)) {
            updateClause.set((Path)this.scpMrpDO.pushFailReason, (Object)pushFailReason);
        } else {
            updateClause.setNull((Path)this.scpMrpDO.pushFailReason);
        }
        updateClause.execute();
    }

    public void updateCalcStatus(List<Long> ids, String calcStatus, String calcFailReason) {
        JPAUpdateClause updateClause = this.jpaQueryFactory.update((EntityPath)this.scpMrpDO).set((Path)this.scpMrpDO.calcStatus, (Object)calcStatus).where(new Predicate[]{this.scpMrpDO.id.in(ids)});
        if (StrUtil.isNotBlank((CharSequence)calcFailReason)) {
            updateClause.set((Path)this.scpMrpDO.calcFailReason, (Object)calcFailReason);
        } else {
            updateClause.setNull((Path)this.scpMrpDO.calcFailReason);
        }
        updateClause.execute();
    }

    public ScpMrpRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.baseBean = Projections.bean(ScpMrpRespVO.class, (Expression[])new Expression[]{this.scpMrpDO.id, this.scpMrpDO.mrpLotNo, this.scpMrpDO.predLotNo, this.scpMrpDO.calcStatus, this.scpMrpDO.pushStatus, this.scpMrpDO.calcFailReason, this.scpMrpDO.pushFailReason, this.scpMrpDO.creator, this.scpMrpDO.createUserId, this.scpMrpDO.createTime, this.scpMrpDO.updater, this.scpMrpDO.modifyUserId, this.scpMrpDO.modifyTime, this.scpMrpDO.remark});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

