package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.boh.StoreReceiveApproveSendParam;
import com.elitesland.scp.dto.order.ScpDemandOrderDRpcDTO;
import com.elitesland.scp.provider.order.ScpDemandOrderDRpcServiceImpl;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 回写订货单关联的门店收货单的审批数量
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class StoreReceiveApproveListener implements MessageQueueListener<StoreReceiveApproveSendParam> {

    private final ScpDemandOrderDRpcServiceImpl scpDemandOrderDRpcServiceImpl;

    @Override
    public @NotEmpty String[] channels() {
        return new String[]{StoreReceiveApproveSendParam.APPROVE_CHANNEL};
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onConsume(@NotBlank String s, @NotNull StoreReceiveApproveSendParam storeReceiveSendParam) {
        log.info("回写门店收货单审批数量：" + JSON.toJSONString(storeReceiveSendParam));

        if (CollectionUtil.isEmpty(storeReceiveSendParam.getOrderDocs())) {
            return;
        }

        // 取消调货单审批通过回调
//        List<ScpDemandOrderDRpcDTO> rpcDTOS = prepareCallbackParam(storeReceiveSendParam);
//        scpDemandOrderDRpcServiceImpl.updateDemandOrderDetail(rpcDTOS);
    }

    private List<ScpDemandOrderDRpcDTO> prepareCallbackParam(StoreReceiveApproveSendParam storeReceiveSendParam) {
        List<ScpDemandOrderDRpcDTO> rpcDTOS = new ArrayList<>();
        storeReceiveSendParam.getOrderDocs().forEach(
                item -> {
                    Long docId = item.getDocId();
                    String docNO = item.getDocNo();
                    List<StoreReceiveApproveSendParam.OrderItem> orderItems = item.getItems();
                    Map<Long, List<StoreReceiveApproveSendParam.OrderItem>> data = orderDidGroup(orderItems);
                    Map<Long, String> lineNoMap = processLineNo(orderItems);
                    Map<Long, BigDecimal> qtyMap = processQty(orderItems);
                    data.keySet().forEach(
                            orderDid -> {
                                ScpDemandOrderDRpcDTO rpcDto = new ScpDemandOrderDRpcDTO();
                                rpcDto.setId(orderDid);
                                rpcDto.setMasId(item.getOrderId());
                                rpcDto.setSrcDocId(docId);
                                rpcDto.setSrcDocNo(docNO);
                                rpcDto.setSrcDocCls("STKTRN");
                                rpcDto.setSrcDocLineNo(lineNoMap.get(orderDid));
                                rpcDto.setAllocationQuantity(qtyMap.get(orderDid));
                                rpcDTOS.add(rpcDto);
                            }
                    );
                }

        );
        log.info("rpcDTOS的值:{}", JSONUtil.toJsonStr(rpcDTOS));
        return rpcDTOS;
    }

    public static Map<Long, List<StoreReceiveApproveSendParam.OrderItem>> orderDidGroup(List<StoreReceiveApproveSendParam.OrderItem> orderItems) {
        return orderItems.stream()
                .collect(Collectors.groupingBy(StoreReceiveApproveSendParam.OrderItem::getOrderDid));
    }

    public static Map<Long, String> processLineNo(List<StoreReceiveApproveSendParam.OrderItem> orderItems) {
        return orderItems.stream()
                .collect(Collectors.groupingBy(StoreReceiveApproveSendParam.OrderItem::getOrderDid,
                        Collectors.mapping(e -> String.valueOf(e.getLineNo()),
                                Collectors.joining(","))));
    }

    public static Map<Long, BigDecimal> processQty(List<StoreReceiveApproveSendParam.OrderItem> orderItems) {
        return orderItems.stream()
                .collect(Collectors.groupingBy(StoreReceiveApproveSendParam.OrderItem::getOrderDid,
                        Collectors.mapping(StoreReceiveApproveSendParam.OrderItem::getQty,
                                Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
    }
}
