package com.elitesland.scp.application.facade.vo.resp.order;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.core.support.common.provider.DefaultUdcProvider;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@ApiModel("订单模板返回")
public class ScpOrderTemplateRespVO extends BaseViewModel implements Serializable {
    @ApiModelProperty("模板类型")
    private String type;

    @ApiModelProperty("单据类型")
    private String docType;
    @ApiModelProperty("单据类型名")
    private String docTypeName;

    @ApiModelProperty("应用门店代码")
    private String storeCode;

    @ApiModelProperty("应用门店名称")
    private String storeName;

    @ApiModelProperty("所属区域")
    private String regionCode;

    @ApiModelProperty("订单截至时间点")
    private Date deadlineTime;

    @ApiModelProperty("开始日期")
    private Date startDate;

    @ApiModelProperty("结束日期")
    private Date endDate;

    @ApiModelProperty("是否启用")
    private Integer isActive;

    public ScpOrderTemplateRespVO update(UdcProvider udcProvider){
        this.docTypeName = udcProvider.getByUdcCode("OB_DOC_TYPE", this.getDocType()).getUdcName();
        return this;
    }
}
