package com.elitesland.scp.infr.repo.calendar;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.*;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.domain.entity.calendar.QScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.infr.dto.calendar.ScpStoreDemandCalendarDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.val;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @description:
 * @author: jeesie.jiang
 * @create: 2024-03-28
 * @Version 1.0
 **/
@Component
public class ScpStoreDemandCalendarRepoProc extends BaseRepoProc<ScpStoreDemandCalendarDO> {

    private static final QScpStoreDemandCalendarDO jpaQDo = QScpStoreDemandCalendarDO.scpStoreDemandCalendarDO;

    public ScpStoreDemandCalendarRepoProc() {
        super(jpaQDo);
    }

    private final QBean<ScpStoreDemandCalendarDTO> demandCalendarList = Projections.bean(
            ScpStoreDemandCalendarDTO.class,
            jpaQDo.id,
            jpaQDo.type,
            jpaQDo.year,
            jpaQDo.month,
            jpaQDo.day,
            jpaQDo.itemType2,
            jpaQDo.workStatus,
            jpaQDo.storeId,
            jpaQDo.storeCode,
            jpaQDo.storeName,
            jpaQDo.sddType
    );


    public PagingVO<ScpStoreDemandCalendarPageVO> searchPage(ScpStoreDemandCalendarPageParamVO param) {
        JPAQuery<ScpStoreDemandCalendarPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(ScpStoreDemandCalendarPageVO.class,
                jpaQDo.storeCode,
                jpaQDo.storeName,
                jpaQDo.storeId,
                jpaQDo.year,
                jpaQDo.month,
                jpaQDo.type,
                jpaQDo.itemType2,
                jpaQDo.sddType
        )).distinct().from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.orderBy(jpaQDo.year.desc(), jpaQDo.month.desc());
        param.setPaging(jpaQuery);
        return PagingVO.<ScpStoreDemandCalendarPageVO>builder()
                .total(getCount(param))
                .records(jpaQuery.fetch())
                .build();
    }


    private Long getCount(ScpStoreDemandCalendarPageParamVO param) {
        val jpaQuery = jpaQueryFactory.selectDistinct(
                jpaQDo.storeCode,
                jpaQDo.itemType2,
                jpaQDo.storeName,
                jpaQDo.storeId,
                jpaQDo.year,
                jpaQDo.month,
                jpaQDo.type,
                jpaQDo.sddType
        ).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return Long.valueOf(jpaQuery.fetch().size());
    }

    public Predicate where(ScpStoreDemandCalendarPageParamVO param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (StringUtils.isNotEmpty(param.getStoreCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.storeCode.eq(param.getStoreCode()));
        }
        if (Objects.nonNull(param.getStoreId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.storeId.eq(param.getStoreId()));
        }
        if (CollectionUtils.isNotEmpty(param.getItemType2s())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemType2.in(param.getItemType2s()));
        }
        if (StringUtils.isNotEmpty(param.getItemType2())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemType2.eq(param.getItemType2()));
        }
        if (param.getStartDate() != null) {
            String year = String.valueOf(param.getStartDate().getYear());

            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
            String month = param.getStartDate().format(formatter);
//            String day = String.valueOf(param.getStartDate().getDayOfMonth());
            predicate = ExpressionUtils.and(predicate, jpaQDo.year.goe(year)
                    .and(jpaQDo.month.goe(month)));

        }
        if (param.getEndDate() != null) {
            String year = String.valueOf(param.getEndDate().getYear());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
            String month = param.getEndDate().format(formatter);
//            String day = String.valueOf(param.getEndDate().getDayOfMonth());
            predicate = ExpressionUtils.and(predicate, jpaQDo.year.loe(year)
                    .and(jpaQDo.month.loe(month)));
        }
        if (Boolean.TRUE.equals(param.getScpmanAuthority())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.storeCode.in(param.getStores()));
        }
        if (param.getFilterDate() != null) {
            String year = String.valueOf(param.getFilterDate().getYear());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
            String month = param.getFilterDate().format(formatter);
            predicate = ExpressionUtils.and(predicate, jpaQDo.year.eq(year).and(jpaQDo.month.eq(month)));
        }
        return predicate;
    }



    public List<ScpStoreDemandCalendarDTO> findStoreCalendarByParam(ScpStoreDemandCalendarParamVO param) {
        JPAQuery<ScpStoreDemandCalendarDTO> jpaQuery = jpaQueryFactory.select(Projections.bean(ScpStoreDemandCalendarDTO.class,
                jpaQDo.storeCode,
                jpaQDo.storeName,
                jpaQDo.itemType2,
                jpaQDo.storeId,
                jpaQDo.year,
                jpaQDo.month,
                jpaQDo.type,
                jpaQDo.day,
                jpaQDo.id,
                jpaQDo.workStatus,
                jpaQDo.createTime,
                jpaQDo.modifyTime,
                jpaQDo.sddType
        )).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.orderBy(jpaQDo.year.desc(), jpaQDo.month.desc(), jpaQDo.day.asc());
        return jpaQuery.fetch();
    }

    public Predicate where(ScpStoreDemandCalendarParamVO param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (StringUtils.isNotEmpty(param.getStoreCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.storeCode.eq(param.getStoreCode()));
        }
        if (StringUtils.isNotEmpty(param.getYear())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.year.eq(param.getYear()));
        }
        if (StringUtils.isNotEmpty(param.getMonth())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.month.eq(param.getMonth()));
        }
        if (StringUtils.isNotEmpty(param.getItemType2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemType2.eq(param.getItemType2()));
        }
        if (CollectionUtils.isNotEmpty(param.getItemType2s())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemType2.in(param.getItemType2s()));
        }
        return predicate;
    }


    public List<ScpStoreDemandCalendarDTO> findDemandCalendarByParam(ScpStoreDemandCalendarParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(demandCalendarList)
                .from(jpaQDo);
        jpaQuery.where(this.whereDemandCalendar(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereDemandCalendar(ScpStoreDemandCalendarParam paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (Objects.nonNull(paramVO.getStoreCode())) {
            predicates.add(jpaQDo.storeCode.eq(paramVO.getStoreCode()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getStoreCodeList())) {
            predicates.add(jpaQDo.storeCode.in(paramVO.getStoreCodeList()));
        }
        if (Objects.nonNull(paramVO.getWorkStatus())) {
            predicates.add(jpaQDo.workStatus.eq(paramVO.getWorkStatus()));
        }
        if (Objects.nonNull(paramVO.getDocType())) {
            predicates.add(jpaQDo.itemType2.eq(paramVO.getDocType()));
        }
        if (StrUtil.isNotBlank(paramVO.getYear())) {
            predicates.add(jpaQDo.year.eq(paramVO.getYear()));
        }
        if (StrUtil.isNotBlank(paramVO.getMonth())) {
            predicates.add(jpaQDo.month.eq(paramVO.getMonth()));
        }
        if (StrUtil.isNotBlank(paramVO.getDay())) {
            predicates.add(jpaQDo.day.eq(paramVO.getDay()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ScpCalendarStoreRespVO> listStoreByQueryParam(ScpCalendarStoreQueryParamVO param) {
        JPAQuery<ScpCalendarStoreRespVO> jpaQuery = jpaQueryFactory.selectDistinct(Projections.bean(ScpCalendarStoreRespVO.class,
                jpaQDo.storeCode,
                jpaQDo.storeName,
                jpaQDo.storeId
        )).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(whereDemandCalendar(param));
        }
        return jpaQuery.fetch();
    }

    private Predicate whereDemandCalendar(ScpCalendarStoreQueryParamVO param) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(Expressions.ONE.eq(Expressions.ONE));
        if (StringUtils.isNotEmpty(param.getWorkStatus())) {
            predicates.add(jpaQDo.workStatus.eq(param.getWorkStatus()));
        }
        if (param.getFindDate() != null) {
            String year = String.valueOf(param.getFindDate().getYear());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
            String month = param.getFindDate().format(formatter);
            DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern("d");
            String day = param.getFindDate().format(dayFormatter);
            predicates.add(jpaQDo.year.eq(year).and(jpaQDo.month.eq(month)).and(jpaQDo.day.eq(day)));
        }
        return ExpressionUtils.allOf(predicates);
    }
    public void deleteByStoreAndYear(List<String> storeCodes, String year) {
        jpaQueryFactory.delete(jpaQDo).where(jpaQDo.storeCode.in(storeCodes).and(jpaQDo.year.eq(year))).execute();
    }
}