package com.elitesland.scp.pay.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.tenpay.business.entpay.mse.sdk.api.AccountBatchBind;
import lombok.Data;

import java.util.Date;

@Data
@JsonPropertyOrder({"api_version", "live_mode", "event_id", "event_type", "pending_webhooks", "create_time", "event_content"})
@JsonTypeName("AccountBindNotifyModel")
public class AccountBindNotifyModel {

    @JsonProperty("api_version")
    private String apiVersion;

    @JsonProperty("live_mode")
    private Boolean liveMode;

    @JsonProperty("event_id")
    private String eventId;

    @JsonProperty("event_type")
    private String eventType;

    @JsonProperty("pending_webhooks")
    private Integer pendingWebhooks;

    @JsonProperty("create_time")
    private Date createTime;

    @JsonProperty("event_content")
    private AccountBatchBind eventContent;

}
