/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserTypeDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoSaveVO;
import com.elitesland.scp.common.Constant;
import com.elitesland.scp.domain.convert.StoreInfoConvert;
import com.elitesland.scp.domain.convert.scpsman.SalesmanInfoConvert;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.dto.authority.ItemObject;
import com.elitesland.scp.dto.authority.StoreAuthorityRespDTO;
import com.elitesland.scp.dto.authority.StoreAuthorityRpcDTO;
import com.elitesland.scp.dto.authority.StoreAuthorityRpcPageDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityDRepo;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityDRepoProc;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepo;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepoProc;
import com.elitesland.scp.infr.repo.scpsman.SalesmanRegionRepo;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.param.StoreAuthorityParam;
import com.elitesland.scp.param.StoreContactParam;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.service.authority.StoreAuthorityRpcService;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcPagingDTO;
import com.elitesland.support.provider.item.param.ItmItemBusinessRpcPagingParam;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/scp/authority"})
public class StoreAuthorityRpcServiceImpl
implements StoreAuthorityRpcService {
    private static final Logger log = LoggerFactory.getLogger(StoreAuthorityRpcServiceImpl.class);
    public static final String SCPSMAN = "scpsman";
    private final RmiOrgStoreRpcService rmiOrgStoreService;
    private final RmiItemService rmiItemService;
    @Autowired
    private UserRpcService userRpcService;
    @Autowired
    private SysSettingService settingService;
    @Autowired
    private OrgOuRpcService orgRpcService;
    @Autowired
    private EmployeeRpcService employeeRpcService;
    @Autowired
    private ScpsmanInfoRepo scpsmanInfoRepo;
    @Autowired
    private SalesmanRegionRepo salesmanRegionRepo;
    @Autowired
    private ScpDemandAuthorityRepo scpDemandAuthorityRepo;
    @Autowired
    private ScpDemandAuthorityRepoProc scpDemandAuthorityRepoProc;
    @Autowired
    private ScpDemandAuthorityDRepo scpDemandAuthorityDRepo;
    @Autowired
    private ScpDemandAuthorityDRepoProc scpDemandAuthorityDRepoProc;
    @Autowired
    private Constant constant;

    @SysCodeProc
    public ApiResult<PagingVO<ItemObject>> getStoreAuthorityDataPage(StoreAuthorityRpcPageDTO storeAuthorityRpcPageDTO) {
        log.info("\u95e8\u5e97\u8981\u8d27\u6743\u9650\u6570\u636e\u5206\u9875\u83b7\u53d6\uff0c\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)storeAuthorityRpcPageDTO));
        String storeCode = storeAuthorityRpcPageDTO.getStoreCode();
        if (StrUtil.isBlank((CharSequence)storeCode)) {
            throw new BusinessException("\u53c2\u6570\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrgStoreBaseRpcDTO storeDto = this.rmiOrgStoreService.getOrgStoreBase(storeCode);
        log.info("\u95e8\u5e97\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)storeDto));
        if (storeDto == null) {
            return ApiResult.ok();
        }
        String ouCode = storeDto.getOuCode();
        String brandCode = storeDto.getBrandCode();
        ItmItemBusinessRpcPagingParam param = new ItmItemBusinessRpcPagingParam();
        if (StrUtil.isNotBlank((CharSequence)ouCode)) {
            param.setBuCodes(Collections.singletonList(ouCode));
        }
        if (StrUtil.isNotBlank((CharSequence)brandCode)) {
            param.setBrandList(Collections.singletonList(brandCode));
        }
        if (StrUtil.isNotBlank((CharSequence)storeAuthorityRpcPageDTO.getItemCodeName())) {
            param.setItemCodeName(storeAuthorityRpcPageDTO.getItemCodeName());
        }
        if (CollUtil.isNotEmpty((Collection)storeAuthorityRpcPageDTO.getItemType2s())) {
            param.setItemType2s(storeAuthorityRpcPageDTO.getItemType2s());
        }
        param.setPurFreeze(storeAuthorityRpcPageDTO.getPurFreeze());
        param.setSaleFreeze(storeAuthorityRpcPageDTO.getSaleFreeze());
        param.setEnable(storeAuthorityRpcPageDTO.getEnable());
        param.setCurrent(Integer.valueOf(storeAuthorityRpcPageDTO.getCurrent() + 2));
        param.setSize(storeAuthorityRpcPageDTO.getSize());
        PagingVO<ItmItemBusinessRpcPagingDTO> itemBusinessRpcDTOS = this.rmiItemService.findItemBusinessRpcDtoByParam(param);
        long total = itemBusinessRpcDTOS.getTotal();
        List records = itemBusinessRpcDTOS.getRecords();
        log.info("\u8c03\u7528\u57fa\u7840\u57df\u5206\u9875\u67e5\u8be2\u5546\u54c1\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)records));
        ArrayList<ItemObject> itemInfoList = new ArrayList<ItemObject>();
        for (ItmItemBusinessRpcPagingDTO dto : records) {
            ItemObject itemInfo = new ItemObject();
            itemInfo.setItemCode(dto.getItemCode());
            itemInfo.setItemId(dto.getItemId());
            itemInfo.setItemName(dto.getItemName());
            itemInfo.setUom(dto.getUom());
            itemInfo.setUomName(dto.getUomName());
            itemInfo.setTaxRate(dto.getTaxRate2());
            itemInfo.setBrand(dto.getBrand());
            itemInfo.setBrandName(dto.getBrandName());
            itemInfo.setItemCateCode(dto.getItemCateCode());
            itemInfo.setItemCateFullName(dto.getItemCateFullName());
            itemInfo.setItemCatePathName(dto.getItemCatePathName());
            itemInfo.setSpec(dto.getSpec());
            itemInfo.setSpuCode(dto.getSpuCode());
            itemInfo.setSpuName(dto.getSpuName());
            itemInfo.setPackageSpec(dto.getPackageSpec());
            itemInfo.setSuppCode(dto.getSuppCode());
            itemInfo.setSuppName(dto.getSuppName());
            itemInfo.setUom2(dto.getUom2());
            itemInfo.setUom2Name(dto.getUom2Name());
            itemInfo.setItemType(dto.getItemType2());
            itemInfo.setSpuId(dto.getSpuId());
            itemInfoList.add(itemInfo);
        }
        PagingVO result = new PagingVO();
        result.setRecords(itemInfoList);
        result.setTotal(total);
        log.info("\u95e8\u5e97\u8981\u8d27\u6743\u9650\u6570\u636e-\u5206\u9875:{}", (Object)JSONUtil.toJsonStr((Object)result));
        return ApiResult.ok((Object)result);
    }

    @Transactional
    public ApiResult updateStoreAuthorityData(StoreAuthorityParam storeAuthorityParam) {
        block23: {
            List mobiles;
            Map<String, List<StoreContactParam>> contacts;
            OrgOuRpcDTO orgOuRpcDTO;
            block22: {
                log.info("\u95e8\u5e97\u8981\u8d27\u6743\u9650\u6570\u636e\u66f4\u65b0\uff0c\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)storeAuthorityParam));
                SysSettingVO sysSettingVO = this.settingService.oneByNo("BELONG_OU");
                if (sysSettingVO == null) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u9ed8\u8ba4\u6240\u5c5e\u516c\u53f8\u914d\u7f6e");
                }
                String ouCodes = sysSettingVO.getSettingVal();
                OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
                orgOuRpcDtoParam.setOuCodes(Collections.singletonList(ouCodes));
                List ouDtoByParam = this.orgRpcService.findOuDtoByParam(orgOuRpcDtoParam);
                orgOuRpcDTO = (OrgOuRpcDTO)ouDtoByParam.get(0);
                List<StoreContactParam> contactParams = storeAuthorityParam.getContactParams().stream().filter(vod -> !StringUtils.isEmpty((CharSequence)vod.getMobile()) && !StringUtils.isEmpty((CharSequence)vod.getType()) && (vod.getType().equals("LEGAL_PERSON") || vod.getType().equals("BUSINESS") || vod.getType().equals("FINANCE"))).toList();
                contacts = contactParams.stream().collect(Collectors.groupingBy(StoreContactParam::getMobile));
                mobiles = contacts.keySet().stream().toList();
                if (!storeAuthorityParam.getStoreType2().equals("DIRECTSALE")) break block22;
                for (String key : contacts.keySet()) {
                    List<ScpsmanAuthorityVO> deleteParam;
                    List<ScpsmanAuthorityVO> authorityVOList1;
                    List oldData;
                    SysUserBasicDTO data = (SysUserBasicDTO)this.userRpcService.getByUsername(key).getData();
                    if (data == null) {
                        List<ScpsmanAuthorityVO> deleteParam2;
                        List<ScpsmanAuthorityVO> authorityVOList12;
                        List oldData2;
                        Long aLong;
                        ScpsmanInfoDO bySalesmanNo = this.scpsmanInfoRepo.findByScpsmanNo(key);
                        SalesmanInfoSaveVO salesmanInfoSaveVO = new SalesmanInfoSaveVO();
                        if (bySalesmanNo != null) {
                            salesmanInfoSaveVO.setId(bySalesmanNo.getId());
                        }
                        StoreContactParam orgContactRpcDTO = contacts.get(key).get(0);
                        salesmanInfoSaveVO.setName(orgContactRpcDTO.getName());
                        salesmanInfoSaveVO.setLoginAccount(key);
                        salesmanInfoSaveVO.setPhone(key);
                        salesmanInfoSaveVO.setScpsmanNo(key);
                        salesmanInfoSaveVO.setSource("ADD");
                        salesmanInfoSaveVO.setBuId(storeAuthorityParam.getBuId());
                        salesmanInfoSaveVO.setEnableStatus(1);
                        salesmanInfoSaveVO.setOuId(storeAuthorityParam.getOuId().toString());
                        salesmanInfoSaveVO.setOuCode(storeAuthorityParam.getOuCode());
                        salesmanInfoSaveVO.setOuName(storeAuthorityParam.getOuName());
                        salesmanInfoSaveVO.setOrgIdBelong(orgOuRpcDTO.getBuId().toString());
                        ScpsmanInfoDO scpsmanInfoDO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveToDO(salesmanInfoSaveVO);
                        EmployeeUpsertDTO upsertDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveVOToUpsertDTO(salesmanInfoSaveVO);
                        if (StringUtils.isNotBlank((CharSequence)salesmanInfoSaveVO.getBirthdayTime())) {
                            upsertDTO.setBirthDate(this.constant.stringToLocalDate(salesmanInfoSaveVO.getBirthdayTime()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)salesmanInfoSaveVO.getJoinTime())) {
                            upsertDTO.setJoinTime(this.constant.swapTimeMin(salesmanInfoSaveVO.getJoinTime()));
                        }
                        if ("EMP".equals(scpsmanInfoDO.getSource())) {
                            upsertDTO.setType("SCPSMAN");
                        }
                        ScpsmanInfoDO save = (ScpsmanInfoDO)((Object)this.scpsmanInfoRepo.save((Object)scpsmanInfoDO));
                        this.buildEmployee(salesmanInfoSaveVO, scpsmanInfoDO, upsertDTO, String.valueOf(save.getId()));
                        List<ScpsmanAuthorityVO> authorityVOList = this.scpDemandAuthorityRepoProc.listQuery(storeAuthorityParam.getStoreCode(), save.getId());
                        ScpsmanAuthorityDO byScpsmanId = this.scpDemandAuthorityRepo.findByScpsmanId(save.getId());
                        ScpsmanAuthorityDO scpManAuthoritySaveVO = new ScpsmanAuthorityDO();
                        if (byScpsmanId != null && (aLong = this.scpDemandAuthorityDRepoProc.queryByMasIdANDStoreCode(byScpsmanId.getId(), storeAuthorityParam.getStoreCode())) != 0L) {
                            scpManAuthoritySaveVO.setId(byScpsmanId.getId());
                        }
                        scpManAuthoritySaveVO.setOuCode(storeAuthorityParam.getOuCode());
                        scpManAuthoritySaveVO.setOuName(storeAuthorityParam.getOuName());
                        scpManAuthoritySaveVO.setOuId(storeAuthorityParam.getOuId());
                        scpManAuthoritySaveVO.setScpsmanNo(save.getScpsmanNo());
                        scpManAuthoritySaveVO.setEnableStatus(true);
                        scpManAuthoritySaveVO.setScpsmanId(save.getId());
                        ScpsmanAuthorityDO save1 = (ScpsmanAuthorityDO)this.scpDemandAuthorityRepo.save(scpManAuthoritySaveVO);
                        List<Long> authId = authorityVOList.stream().map(ScpsmanAuthorityVO::getAuthorityId).distinct().collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(authId)) {
                            log.info("\u5220\u9664\u7684\u6570\u636eID\u6761\u4ef6" + authId);
                            this.scpDemandAuthorityDRepo.deleteByMasIdInAndAuthSource(authId, ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                        }
                        ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
                        scpsmanAuthorityDDO.setAuthSource(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                        scpsmanAuthorityDDO.setMasId(save1.getId());
                        scpsmanAuthorityDDO.setType(0);
                        scpsmanAuthorityDDO.setRegion(storeAuthorityParam.getRegion());
                        scpsmanAuthorityDDO.setStWhId(storeAuthorityParam.getStoreId());
                        scpsmanAuthorityDDO.setStWhCode(storeAuthorityParam.getStoreCode());
                        scpsmanAuthorityDDO.setStWhName(storeAuthorityParam.getStoreName());
                        this.scpDemandAuthorityDRepo.save(scpsmanAuthorityDDO);
                        if (CollectionUtils.isNotEmpty(authorityVOList) && CollectionUtils.isNotEmpty(oldData2 = authorityVOList.stream().filter(vo -> !vo.getAuthSource().equals(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode())).collect(Collectors.toList()))) {
                            List<Long> oldAuthData = oldData2.stream().map(ScpsmanAuthorityVO::getAuthorityDid).collect(Collectors.toList());
                            this.scpDemandAuthorityDRepoProc.updateMasId(oldAuthData, save1.getId());
                        }
                        if (!CollectionUtils.isNotEmpty(authorityVOList12 = this.scpDemandAuthorityRepoProc.queryByStoreCode(storeAuthorityParam.getStoreCode())) || !CollectionUtils.isNotEmpty(deleteParam2 = authorityVOList12.stream().filter(vo -> !mobiles.contains(vo.getScpsmanNo())).collect(Collectors.toList()))) continue;
                        deleteParam2.forEach(an -> {
                            Long aLong = this.scpDemandAuthorityDRepoProc.queryByMasIdANDStoreCode(an.getAuthorityId(), storeAuthorityParam.getStoreCode());
                            if (aLong == 0L) {
                                this.scpDemandAuthorityRepo.deleteById(an.getAuthorityId());
                                this.scpDemandAuthorityDRepo.deleteByMasId(an.getAuthorityId());
                            } else {
                                this.scpDemandAuthorityDRepo.deleteByMasIdAndStWhCodeAndAuthSource(an.getAuthorityId(), storeAuthorityParam.getStoreCode(), ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                            }
                        });
                        continue;
                    }
                    ScpsmanInfoDO save = this.scpsmanInfoRepo.findByScpsmanNo(key);
                    List<ScpsmanAuthorityVO> authorityVOList = this.scpDemandAuthorityRepoProc.listQuery(storeAuthorityParam.getStoreCode(), save.getId());
                    ScpsmanAuthorityDO byScpsmanId = this.scpDemandAuthorityRepo.findByScpsmanId(save.getId());
                    ScpsmanAuthorityDO scpManAuthoritySaveVO = new ScpsmanAuthorityDO();
                    if (byScpsmanId != null) {
                        Long aLong = this.scpDemandAuthorityDRepoProc.queryByMasIdANDStoreCode(byScpsmanId.getId(), storeAuthorityParam.getStoreCode());
                        if (aLong == 0L) {
                            this.scpDemandAuthorityRepo.deleteById(byScpsmanId.getId());
                        } else {
                            scpManAuthoritySaveVO.setId(byScpsmanId.getId());
                        }
                    }
                    scpManAuthoritySaveVO.setOuCode(storeAuthorityParam.getOuCode());
                    scpManAuthoritySaveVO.setOuName(storeAuthorityParam.getOuName());
                    scpManAuthoritySaveVO.setOuId(storeAuthorityParam.getOuId());
                    scpManAuthoritySaveVO.setScpsmanNo(save.getScpsmanNo());
                    scpManAuthoritySaveVO.setEnableStatus(true);
                    scpManAuthoritySaveVO.setScpsmanId(save.getId());
                    ScpsmanAuthorityDO save1 = (ScpsmanAuthorityDO)this.scpDemandAuthorityRepo.save(scpManAuthoritySaveVO);
                    List<Long> authId = authorityVOList.stream().map(ScpsmanAuthorityVO::getAuthorityId).distinct().collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(authId)) {
                        log.info("\u5220\u9664\u7684\u6570\u636eID\u6761\u4ef6" + authId);
                        this.scpDemandAuthorityDRepo.deleteByMasIdInAndAuthSource(authId, ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                    }
                    ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
                    scpsmanAuthorityDDO.setAuthSource(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                    scpsmanAuthorityDDO.setMasId(save1.getId());
                    scpsmanAuthorityDDO.setType(0);
                    scpsmanAuthorityDDO.setRegion(storeAuthorityParam.getRegion());
                    scpsmanAuthorityDDO.setStWhId(storeAuthorityParam.getStoreId());
                    scpsmanAuthorityDDO.setStWhCode(storeAuthorityParam.getStoreCode());
                    scpsmanAuthorityDDO.setStWhName(storeAuthorityParam.getStoreName());
                    this.scpDemandAuthorityDRepo.save(scpsmanAuthorityDDO);
                    if (CollectionUtils.isNotEmpty(authorityVOList) && CollectionUtils.isNotEmpty(oldData = authorityVOList.stream().filter(vo -> !vo.getAuthSource().equals(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode())).collect(Collectors.toList()))) {
                        List<Long> oldAuthData = oldData.stream().map(ScpsmanAuthorityVO::getAuthorityDid).collect(Collectors.toList());
                        this.scpDemandAuthorityDRepoProc.updateMasId(oldAuthData, save1.getId());
                    }
                    if (!CollectionUtils.isNotEmpty(authorityVOList1 = this.scpDemandAuthorityRepoProc.queryByStoreCode(storeAuthorityParam.getStoreCode())) || !CollectionUtils.isNotEmpty(deleteParam = authorityVOList1.stream().filter(vo -> !mobiles.contains(vo.getScpsmanNo())).collect(Collectors.toList()))) continue;
                    deleteParam.forEach(an -> {
                        Long aLong = this.scpDemandAuthorityDRepoProc.queryByMasIdANDStoreCode(an.getAuthorityId(), storeAuthorityParam.getStoreCode());
                        if (aLong == 0L) {
                            this.scpDemandAuthorityRepo.deleteById(an.getAuthorityId());
                            this.scpDemandAuthorityDRepo.deleteByMasId(an.getAuthorityId());
                        } else {
                            this.scpDemandAuthorityDRepo.deleteByMasIdAndStWhCodeAndAuthSource(an.getAuthorityId(), storeAuthorityParam.getStoreCode(), ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                        }
                    });
                }
                break block23;
            }
            if (!storeAuthorityParam.getStoreType2().equals("DIRECTSALE2")) break block23;
            for (String key : contacts.keySet()) {
                List<ScpsmanAuthorityVO> deleteParam;
                List<ScpsmanAuthorityVO> authorityVOList1;
                List oldData;
                SysUserBasicDTO data = (SysUserBasicDTO)this.userRpcService.getByUsername(key).getData();
                if (data == null) continue;
                SysEmployeeBasicDTO empData = (SysEmployeeBasicDTO)this.employeeRpcService.getByUserId(data.getId()).getData();
                ScpsmanInfoDO bySalesmanNo = this.scpsmanInfoRepo.findByScpsmanNo(empData.getCode());
                SalesmanInfoSaveVO salesmanInfoSaveVO = new SalesmanInfoSaveVO();
                if (bySalesmanNo != null) {
                    salesmanInfoSaveVO.setId(bySalesmanNo.getId());
                }
                salesmanInfoSaveVO.setEmail(empData.getEmail());
                salesmanInfoSaveVO.setName(empData.getLastName());
                salesmanInfoSaveVO.setLoginAccount(key);
                salesmanInfoSaveVO.setPhone(key);
                salesmanInfoSaveVO.setScpsmanNo(empData.getCode());
                salesmanInfoSaveVO.setSource("EMP");
                salesmanInfoSaveVO.setBuId(empData.getOrgId());
                ScpsmanInfoDO scpsmanInfoDO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveToDO(salesmanInfoSaveVO);
                scpsmanInfoDO.setEnableStatus(1);
                scpsmanInfoDO.setOuId(orgOuRpcDTO.getId());
                scpsmanInfoDO.setOuCode(orgOuRpcDTO.getOuCode());
                scpsmanInfoDO.setOuName(orgOuRpcDTO.getOuName());
                ScpsmanInfoDO save = (ScpsmanInfoDO)((Object)this.scpsmanInfoRepo.save((Object)scpsmanInfoDO));
                List<ScpsmanAuthorityVO> authorityVOList = this.scpDemandAuthorityRepoProc.listQuery(storeAuthorityParam.getStoreCode(), save.getId());
                ScpsmanAuthorityDO byScpsmanId = this.scpDemandAuthorityRepo.findByScpsmanId(save.getId());
                ScpsmanAuthorityDO scpManAuthoritySaveVO = new ScpsmanAuthorityDO();
                if (byScpsmanId != null) {
                    Long aLong = this.scpDemandAuthorityDRepoProc.queryByMasIdANDStoreCode(byScpsmanId.getId(), storeAuthorityParam.getStoreCode());
                    if (aLong == 0L) {
                        this.scpDemandAuthorityRepo.deleteById(byScpsmanId.getId());
                    } else {
                        scpManAuthoritySaveVO.setId(byScpsmanId.getId());
                    }
                }
                scpManAuthoritySaveVO.setOuCode(storeAuthorityParam.getOuCode());
                scpManAuthoritySaveVO.setOuName(storeAuthorityParam.getOuName());
                scpManAuthoritySaveVO.setOuId(storeAuthorityParam.getOuId());
                scpManAuthoritySaveVO.setScpsmanNo(save.getScpsmanNo());
                scpManAuthoritySaveVO.setEnableStatus(true);
                scpManAuthoritySaveVO.setScpsmanId(save.getId());
                ScpsmanAuthorityDO save1 = (ScpsmanAuthorityDO)this.scpDemandAuthorityRepo.save(scpManAuthoritySaveVO);
                List<Long> authId = authorityVOList.stream().map(ScpsmanAuthorityVO::getAuthorityId).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(authId)) {
                    log.info("\u5220\u9664\u7684\u6570\u636eID\u6761\u4ef6" + authId);
                    this.scpDemandAuthorityDRepo.deleteByMasIdInAndAuthSource(authId, ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                }
                ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
                scpsmanAuthorityDDO.setAuthSource(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                scpsmanAuthorityDDO.setMasId(save1.getId());
                scpsmanAuthorityDDO.setType(0);
                scpsmanAuthorityDDO.setRegion(storeAuthorityParam.getRegion());
                scpsmanAuthorityDDO.setStWhId(storeAuthorityParam.getStoreId());
                scpsmanAuthorityDDO.setStWhCode(storeAuthorityParam.getStoreCode());
                scpsmanAuthorityDDO.setStWhName(storeAuthorityParam.getStoreName());
                this.scpDemandAuthorityDRepo.save(scpsmanAuthorityDDO);
                if (CollectionUtils.isNotEmpty(authorityVOList) && CollectionUtils.isNotEmpty(oldData = authorityVOList.stream().filter(vo -> !vo.getAuthSource().equals(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode())).collect(Collectors.toList()))) {
                    List<Long> oldAuthData = oldData.stream().map(ScpsmanAuthorityVO::getAuthorityDid).collect(Collectors.toList());
                    this.scpDemandAuthorityDRepoProc.updateMasId(oldAuthData, save1.getId());
                }
                if (!CollectionUtils.isNotEmpty(authorityVOList1 = this.scpDemandAuthorityRepoProc.queryByStoreCode(storeAuthorityParam.getStoreCode())) || !CollectionUtils.isNotEmpty(deleteParam = authorityVOList1.stream().filter(vo -> !mobiles.contains(vo.getScpsmanNo())).collect(Collectors.toList()))) continue;
                deleteParam.forEach(an -> {
                    Long aLong = this.scpDemandAuthorityDRepoProc.queryByMasIdANDStoreCode(an.getAuthorityId(), storeAuthorityParam.getStoreCode());
                    if (aLong == 0L) {
                        this.scpDemandAuthorityRepo.deleteById(an.getAuthorityId());
                        this.scpDemandAuthorityDRepo.deleteByMasId(an.getAuthorityId());
                    } else {
                        this.scpDemandAuthorityDRepo.deleteByMasIdAndStWhCodeAndAuthSource(an.getAuthorityId(), storeAuthorityParam.getStoreCode(), ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                    }
                });
            }
        }
        return ApiResult.ok();
    }

    @SysCodeProc
    public ApiResult<StoreAuthorityRespDTO> getStoreAuthorityData(StoreAuthorityRpcDTO storeAuthorityRpcDTO) {
        String storeCode = storeAuthorityRpcDTO.getStoreCode();
        if (StrUtil.isBlank((CharSequence)storeCode)) {
            throw new BusinessException("\u53c2\u6570\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrgStoreBaseRpcDTO storeDto = this.rmiOrgStoreService.getOrgStoreBase(storeCode);
        log.info("\u95e8\u5e97\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)storeDto));
        if (storeDto == null) {
            return ApiResult.ok();
        }
        StoreAuthorityRespDTO storeAuthorityRespDTO = StoreInfoConvert.INSTANCE.toStoreAuthorityRespDTO(storeDto);
        String ouCode = storeAuthorityRespDTO.getOuCode();
        String brandCode = storeAuthorityRespDTO.getBrandCode();
        List<ItmItemBusinessRpcDTO> itmItemBusinessRpcDTOS = this.rmiItemService.findItmItemBusinessByBUCodeAndBrand(ouCode, brandCode);
        log.info("\u8c03\u7528\u57fa\u7840\u57df\u67e5\u8be2\u5546\u54c1\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(itmItemBusinessRpcDTOS));
        ArrayList<StoreAuthorityRespDTO.ItemInfo> itemInfoList = new ArrayList<StoreAuthorityRespDTO.ItemInfo>();
        for (ItmItemBusinessRpcDTO dto : itmItemBusinessRpcDTOS) {
            StoreAuthorityRespDTO.ItemInfo itemInfo = new StoreAuthorityRespDTO.ItemInfo();
            itemInfo.setItemCode(dto.getItemCode());
            itemInfo.setItemId(dto.getId());
            itemInfo.setItemName(dto.getItemName());
            itemInfo.setUom(dto.getUom());
            itemInfo.setUomName(dto.getUomName());
            itemInfo.setTaxRate(dto.getTaxRate2());
            itemInfoList.add(itemInfo);
        }
        storeAuthorityRespDTO.setItemInfos(itemInfoList);
        log.info("\u95e8\u5e97\u8981\u8d27\u6743\u9650\u6570\u636e:{}", (Object)JSONUtil.toJsonStr((Object)storeAuthorityRespDTO));
        return ApiResult.ok((Object)storeAuthorityRespDTO);
    }

    private void buildEmployee(SalesmanInfoSaveVO salesmanInfoSaveVO, ScpsmanInfoDO scpsmanInfoDO, EmployeeUpsertDTO employeeUpsertDTO, String id) {
        Long userId;
        Long empId = salesmanInfoSaveVO.getUserId();
        if (empId != null && (userId = (Long)this.userRpcService.getIdByUsername(scpsmanInfoDO.getLoginAccount()).computeData()) != null) {
            this.userRpcService.addUserType(userId, SCPSMAN, id);
            return;
        }
        AreaVO areaVO = new AreaVO();
        areaVO.setProvinceCode(salesmanInfoSaveVO.getProvince());
        areaVO.setCityCode(salesmanInfoSaveVO.getCity());
        areaVO.setCountyCode(salesmanInfoSaveVO.getArea());
        EmployeeUpsertDTO.EmployeeOrg employeeOrg = new EmployeeUpsertDTO.EmployeeOrg();
        employeeOrg.setOrgId(salesmanInfoSaveVO.getBuId());
        employeeOrg.setLeaderUserId(salesmanInfoSaveVO.getLeaderUserId());
        if (salesmanInfoSaveVO.getSex() != null) {
            employeeUpsertDTO.setGender(salesmanInfoSaveVO.getSex().equals(1) ? "MALE" : "FEMALE");
        }
        employeeUpsertDTO.setAreaVO(areaVO);
        if (StrUtil.isNotBlank((CharSequence)salesmanInfoSaveVO.getPhone())) {
            employeeUpsertDTO.setPhone(salesmanInfoSaveVO.getPhone());
        }
        employeeUpsertDTO.setId(empId);
        employeeUpsertDTO.setOrgList(List.of(employeeOrg));
        employeeUpsertDTO.setCode(scpsmanInfoDO.getScpsmanNo());
        employeeUpsertDTO.setOuterKey(salesmanInfoSaveVO.getOuterKey());
        this.appendUserTypeToEmployeeUpsertDTO(employeeUpsertDTO, id);
        ApiResult result = this.employeeRpcService.upsert(employeeUpsertDTO);
        if (!result.isSuccess()) {
            throw new BusinessException(result.getMsg() + " \u4fdd\u5b58\u5458\u5de5\u5931\u8d25");
        }
    }

    private void appendUserTypeToEmployeeUpsertDTO(EmployeeUpsertDTO employeeUpsertDTO, String id) {
        SysUserTypeDTO sysUserTypeDTO = new SysUserTypeDTO();
        sysUserTypeDTO.setIdentityId(id);
        sysUserTypeDTO.setUserType(SCPSMAN);
        employeeUpsertDTO.setUserTypeList(Collections.singletonList(sysUserTypeDTO));
    }

    public StoreAuthorityRpcServiceImpl(RmiOrgStoreRpcService rmiOrgStoreService, RmiItemService rmiItemService) {
        this.rmiOrgStoreService = rmiOrgStoreService;
        this.rmiItemService = rmiItemService;
    }
}

