/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.strategy;

import com.elitesland.scp.application.enums.AllocRuleType;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderComputeVO;
import com.elitesland.scp.application.service.strategy.EventStrategy;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AvgEventService
implements EventStrategy {
    private static final Logger log = LoggerFactory.getLogger(AvgEventService.class);

    @Override
    public void handleInvStk(List<ScpDemandOrderComputeVO> stores, BigDecimal warehouse) {
        BigDecimal average = warehouse.divide(BigDecimal.valueOf(stores.size()), 0, RoundingMode.DOWN);
        for (ScpDemandOrderComputeVO store : stores) {
            BigDecimal allocation = average.min(store.getAllocationDeQuantity());
            store.setPlanQuantity(allocation);
            warehouse = warehouse.subtract(allocation);
        }
        for (ScpDemandOrderComputeVO store : stores) {
            while (store.getPlanQuantity().compareTo(store.getAllocationDeQuantity()) < 0 && warehouse.compareTo(BigDecimal.ZERO) > 0) {
                store.setPlanQuantity(store.getPlanQuantity().add(BigDecimal.ONE));
                warehouse = warehouse.subtract(BigDecimal.ONE);
            }
        }
    }

    @Override
    public String getAllocRuleType() {
        return AllocRuleType.AVERAGE.getCode();
    }
}

