/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.lakalapay.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.TreeSet;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class RSA {
    public static final String SIGN_ALGORITHMS = "SHA1WithRSA";
    public static final String KEY_ALGORITHM = "RSA";
    public static final String CIPHER_ALGORITHM = "RSA/ECB/PKCS1PADDING";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static String sign(String content, String privateKey, String input_charset) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
            KeyFactory keyf = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            signature.update(content.getBytes(input_charset));
            byte[] signed = signature.sign();
            return Base64.encodeBase64String((byte[])signed);
        }
        catch (Exception e) {
            System.err.println("\u7b7e\u540d\u5f02\u5e38" + e.getMessage());
            return null;
        }
    }

    public static boolean verify(String content, String sign, String ali_public_key, String input_charset) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            byte[] encodedKey = Base64.decodeBase64((String)ali_public_key);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(input_charset));
            boolean bverify = signature.verify(Base64.decodeBase64((String)sign));
            return bverify;
        }
        catch (Exception e) {
            System.err.println("\u9a8c\u8bc1\u5f02\u5e38" + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encryptByPublicKey(String srcData, String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        ByteArrayOutputStream out = null;
        try {
            byte[] keyBytes = Base64.decodeBase64((byte[])publicKey.getBytes());
            byte[] data = srcData.getBytes("utf-8");
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(1, publicK);
            int inputLen = data.length;
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            String string = Base64.encodeBase64String((byte[])encryptedData);
            return string;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getSignHmacSHA256(Map<String, Object> params, String secret) {
        String sortStr = null;
        try {
            sortStr = RSA.getSortedParam(params);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u53c2\u6570\u6392\u5e8f\u5931\u8d25", e);
        }
        return RSA.signHS256(secret, sortStr);
    }

    public static String getSortedParam(Map<String, Object> params) throws UnsupportedEncodingException {
        TreeSet<String> sortedParams = new TreeSet<String>(params.keySet());
        StringBuilder sortedParamStr = new StringBuilder();
        for (String key : sortedParams) {
            String value = String.valueOf(params.get(key));
            if (null == value || "".equals(value) || "sign".equalsIgnoreCase(key)) continue;
            sortedParamStr.append(key + "=" + URLEncoder.encode(value, "UTF-8") + "&");
        }
        return sortedParamStr.substring(0, sortedParamStr.length() - 1);
    }

    public static String signHS256(String appSecret, String baseUrl) {
        try {
            Mac hs256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(appSecret.getBytes("UTF-8"), "HmacSHA256");
            hs256.init(secretKey);
            byte[] bytes = hs256.doFinal(baseUrl.getBytes("UTF-8"));
            return RSA.toHex(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301HmacSHA256\u7b97\u6cd5", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301utf8\u7f16\u7801", e);
        }
        catch (Exception e) {
            throw new RuntimeException("hs256\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public static String toHex(byte[] bytes) {
        StringBuffer hexstr = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() < 2) {
                hexstr.append(0);
            }
            hexstr.append(b);
        }
        return hexstr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encryptByPrivateKey(String srcData, String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        ByteArrayOutputStream out = null;
        try {
            byte[] keyBytes = Base64.decodeBase64((byte[])privateKey.getBytes());
            byte[] data = srcData.getBytes("utf-8");
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(1, privateK);
            int inputLen = data.length;
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            String string = Base64.encodeBase64String((byte[])encryptedData);
            return string;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decryptByPublicKey(String srcData, String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        ByteArrayOutputStream out = null;
        try {
            byte[] keyBytes = Base64.decodeBase64((byte[])publicKey.getBytes());
            byte[] encryptedData = Base64.decodeBase64((byte[])srcData.getBytes());
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(2, publicK);
            int inputLen = encryptedData.length;
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            String string = new String(decryptedData, "utf-8");
            return string;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decryptByPrivateKey(String srcData, String privateKey) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        ByteArrayOutputStream out = null;
        try {
            byte[] keyBytes = Base64.decodeBase64((byte[])privateKey.getBytes());
            byte[] encryptedData = Base64.decodeBase64((String)srcData);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(2, privateK);
            int inputLen = encryptedData.length;
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            String string = new String(decryptedData, "utf-8");
            return string;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

