package com.elitesland.scp.domain.service.supalloc;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationExportRespVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationPageParamVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationPageVO;
import com.elitesland.scp.domain.convert.ScpSupplyAllocationConvert;
import com.elitesland.scp.domain.entity.supalloc.ScpSupplyAllocationDO;
import com.elitesland.scp.infr.dto.supalloc.ScpSupplyAllocationDTO;
import com.elitesland.scp.infr.repo.supalloc.ScpSupplyAllocationRepo;
import com.elitesland.scp.infr.repo.supalloc.ScpSupplyAllocationRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;


/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 25日 13:55
 * @version: 1.0
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ScpSupplyAllocationDomainServiceImpl implements ScpSupplyAllocationDomainService {

    private final ScpSupplyAllocationRepoProc scpSupplyAllocationRepoProc;

    private final ScpSupplyAllocationRepo scpSupplyAllocationRepo;



    @Override
    @SysCodeProc
    public PagingVO<ScpSupplyAllocationPageVO> page(ScpSupplyAllocationPageParamVO param) {
        PagingVO<ScpSupplyAllocationPageVO> page = scpSupplyAllocationRepoProc.page(param);
        if(CollectionUtils.isNotEmpty(page.getRecords())){
            List<String> concatKey = page.getRecords().stream().map(d -> d.getStoreWhCode() + d.getItemCode()).collect(Collectors.toList());
            List<ScpSupplyAllocationDO> allocationDOS = scpSupplyAllocationRepo.findByConcatKey(concatKey);
            Map<String, List<ScpSupplyAllocationDO>> groupMap = allocationDOS.stream().collect(Collectors.groupingBy(d -> d.getStoreWhCode() + d.getItemCode()));
            page.getRecords().forEach(d ->{
                List<ScpSupplyAllocationDO> supplyAllocationDOS = groupMap.get(d.getStoreWhCode() + d.getItemCode());
                if(supplyAllocationDOS != null){
                    BigDecimal sum = supplyAllocationDOS.stream().map(ScpSupplyAllocationDO::getAllocation)
                            .filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    d.setAllocationTotal(sum);
                }
            });
        }
        return page;
    }

    @Override
    public List<ScpSupplyAllocationDO> findByConcatKeys(Set<String> concatKeys) {
        List<String> stringList = new ArrayList<>(concatKeys);
        return scpSupplyAllocationRepo.findByConcatKey(stringList);
    }

    @Override
    public List<ScpSupplyAllocationDO> findAllByConcatKey(List<String> cocatKeys) {
        return scpSupplyAllocationRepo.findAllByConcatKey(cocatKeys);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByBusinessKey(Set<String> concatKeys) {
        scpSupplyAllocationRepo.deleteByBusinessKey(concatKeys);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(List<ScpSupplyAllocationDTO> createBatch) {
        scpSupplyAllocationRepo.saveAll(createBatch.stream()
                .map(ScpSupplyAllocationConvert.INSTANCE::dtoToDo)
                .collect(Collectors.toList()));
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<Long> ids) {
        scpSupplyAllocationRepo.deleteAllById(ids);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpSupplyAllocationExportRespVO> exportSearch(ScpSupplyAllocationPageParamVO queryParam) {
        log.info("ScpSupplyAllocation export start...");
        PagingVO<ScpSupplyAllocationExportRespVO> exportSearch = scpSupplyAllocationRepoProc.exportSearch(queryParam);
        log.info("ScpSupplyAllocation export end...");
        if(CollectionUtils.isNotEmpty(exportSearch.getRecords())){
            List<String> concatKey = exportSearch.getRecords().stream().map(d -> d.getStoreWhCode() + d.getItemCode()).collect(Collectors.toList());
            List<ScpSupplyAllocationDO> allocationDOS = scpSupplyAllocationRepo.findByConcatKey(concatKey);
            Map<String, List<ScpSupplyAllocationDO>> groupMap = allocationDOS.stream().collect(Collectors.groupingBy(d -> d.getStoreWhCode() + d.getItemCode()));
            exportSearch.getRecords().forEach(d ->{
                d.setStatusName("启用");
                if(Boolean.FALSE.equals(d.getStatus())){
                    d.setStatusName("禁用");
                }
                List<ScpSupplyAllocationDO> supplyAllocationDOS = groupMap.get(d.getStoreWhCode() + d.getItemCode());
                if(supplyAllocationDOS != null){
                    BigDecimal sum = supplyAllocationDOS.stream().map(ScpSupplyAllocationDO::getAllocation)
                            .filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    d.setAllocationTotal(sum);
                }
            });
        }
        return exportSearch;
    }

    @Override
    public List<ScpSupplyAllocationDO> findByIds(List<Long> ids) {
        return scpSupplyAllocationRepo.findByIdIn(ids);
    }
}
