package com.elitesland.scp.application.facade.vo.calendar;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2024-04-01
* @Version 1.0
**/

@Data
@ApiModel(value = "scpSuppDemandCalendarSaveVO", description = "送货日历保存")
public class ScpSuppDemandCalendarSaveVO implements Serializable {

    @ApiModelProperty(value = "门店id")
    private Long suppId;

    @ApiModelProperty(value = "门店编码")
    private String suppCode;

    @ApiModelProperty(value = "门店名称")
    private String suppName;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "门店id/门店仓库id")
    private Long storeWhId;

    @ApiModelProperty(value = "仓库编码/门店编码")
    private String storeWhCode;

    @ApiModelProperty(value = "仓库名称/门店名称")
    private String storeWhName;

    @ApiModelProperty(value = "年")
    private String year;

    @ApiModelProperty(value = "月")
    private String month;

    @ApiModelProperty(value = "工作日明细")
    private List<ScpSuppDemandCalendarSaveVO.CalendarDayDetail> details;

    @Data
    @ApiModel(value = "calendarDayDetail", description = "保存明细")
    public static class CalendarDayDetail extends BaseViewModel implements Serializable {

        @ApiModelProperty(value = "日")
        private String day;

        @ApiModelProperty(value = "工作状态")
        private String workStatus;
    }




}