package com.elitesland.scp.domain.convert.scpsman;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitesland.scp.application.facade.vo.scpsman.*;
import com.elitesland.scp.application.service.scpsman.StandardScpsmanImportEntity;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanRegionDO;
import com.elitesland.scp.dto.scpsman.SalemanCustDTO;
import com.elitesland.scp.dto.scpsman.SalesmanLevelInfoDTO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 19:28
 * @Description:
 */
@Mapper(config = BaseMapperConfig.class)
public interface SalesmanInfoConvert {

    SalesmanInfoConvert INSTANCE = Mappers.getMapper(SalesmanInfoConvert.class);

    ScpsmanInfoDO salesmanInfoSaveToDO(SalesmanInfoSaveVO salesmanInfoSaveVO);
    ScpsmanInfoDO salesmanImportSaveToDO(SalesmanImportSaveVO salesmanInfoSaveVO);
    @Mapping(target = "jurisdiction", ignore = true)
    SalesmanInfoDetailRespVO salesmanInfoDOToDetailRespVO(ScpsmanInfoDO scpsmanInfoDO);

    @Mappings({
            @Mapping(source = "name",target = "fullName"),
            @Mapping(source = "loginAccount",target = "username"),
            @Mapping(source = "sex",target = "gender"),
            @Mapping(source = "idCardNo",target = "idCard"),
            @Mapping(source = "detailedAddress",target = "address"),
            @Mapping(target = "id", ignore = true),
            @Mapping(target = "joinTime", ignore = true),
    })
    EmployeeUpsertDTO salesmanInfoSaveVOToUpsertDTO(SalesmanInfoSaveVO salesmanInfoSaveVO);

    @Mappings({
            @Mapping(source = "name",target = "fullName"),
            @Mapping(source = "loginAccount",target = "username"),
            @Mapping(source = "sex",target = "gender"),
            @Mapping(source = "idCardNo",target = "idCard"),
            @Mapping(source = "detailedAddress",target = "address"),
            @Mapping(target = "id", ignore = true),
            @Mapping(target = "joinTime", ignore = true),
    })
    EmployeeUpsertDTO salesmanImportSaveVOToUpsertDTO(SalesmanImportSaveVO salesmanInfoSaveVO);

    @Mappings({
            @Mapping(source = "loginAccount",target = "username"),
    })
    EmployeePageQueryDTO salesmanInfoQueryVOToQueryDTO(SalesmanInfoQueryVO salesmanInfoQueryVO);

    List<EmployeeInfoRespVO> employeePageRespDTOToEmployeeInfoRespVO(List<EmployeePageRespDTO> employeePageRespDTO);

    EmployeeDetailInfoRespVO SysEmployeeDetailDTOToRespVO(SysEmployeeDetailDTO sysEmployeeDetailDTO);

    List<EmployeeInfoRespVO> employeeUnderlingDTOToRespVO(List<EmployeeUnderlingDTO> employeeInfoRespVO);

    List<SalesmanRegionVO> salesmanRegionDOToVo(List<ScpsmanRegionDO> scpsmanRegionDOS);

    SalemanCustDTO salesmanCoverLevel(SalesmanLevelInfoDTO salesmanLevelInfoDTO);

    SalesmanImportSaveVO toSalesmanImportSaveVO( StandardScpsmanImportEntity entity);

    List<SalesmanImportSaveVO> toSalesmanImportSaveVOS( List<StandardScpsmanImportEntity> entityList);
}
