/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.mrp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.pur.provider.PurSuppProvider;
import com.elitesland.scp.application.facade.vo.param.item.ScpMrpDImportSaveVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpDImportEntity;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDRespVO;
import com.elitesland.scp.application.facade.vo.save.mrp.ScpMrpDPlanSaveVO;
import com.elitesland.scp.domain.service.mrp.ScpMrpDDomainService;
import com.elitesland.scp.domain.service.mrp.ScpMrpDPlanDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class ScpMrpDImportService
implements DataImport<ScpMrpDImportEntity> {
    private static final Logger log = LoggerFactory.getLogger(ScpMrpDImportService.class);
    private static final String LINE = "\n";
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u6821\u9a8c\u5f02\u5e38: {2}; ";
    private final TransactionTemplate transactionTemplate;
    private final ScpMrpDDomainService scpMrpDDomainService;
    private final ScpMrpDPlanDomainService scpMrpDPlanDomainService;
    private final OrgOuRpcService orgOuRpcService;
    private final PurSuppProvider purSuppProvider;

    public Set<Integer> sheetNoList() {
        return Collections.singleton(1);
    }

    public Integer stepSize() {
        return 1000000;
    }

    public String getTmplCode() {
        return "yst_scp_mrp_d_import";
    }

    public List<String> executeImport(List<ScpMrpDImportEntity> dataList, int startRowIndex) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        try {
            List<String> errorMsg = this.checkAndSaveData(dataList, startRowIndex);
            if (CollectionUtil.isNotEmpty(errorMsg)) {
                log.info("MRP\u8ba1\u5212\u660e\u7ec6\u5bfc\u5165\u5b8c\u6210,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b:{}", (Object)JSONUtil.toJsonStr(errorMsg));
            } else {
                log.info("MRP\u8ba1\u5212\u660e\u7ec6\u5bfc\u5165\u5b8c\u6210,\u672a\u53d1\u751f\u9519\u8bef");
            }
            return errorMsg;
        }
        catch (Exception e) {
            for (ScpMrpDImportEntity entity : dataList) {
                errors.add(e.getMessage());
            }
            return errors;
        }
    }

    private List<String> checkAndSaveData(List<ScpMrpDImportEntity> dataList, int startRowIndex) {
        LinkedHashMap<Integer, String> errMsgMap = new LinkedHashMap<Integer, String>();
        Integer index = 0;
        for (ScpMrpDImportEntity entity : dataList) {
            entity.setRowNo(index);
            errMsgMap.put(index, null);
            Integer n = index;
            index = index + 1;
        }
        log.info("startRowIndex\u7684\u503c:{}", (Object)startRowIndex);
        HashSet<Long> errorIdSet = new HashSet<Long>();
        List<ScpMrpDImportSaveVO> dataToSave = this.prepareData(dataList, errMsgMap, errorIdSet);
        log.info("MRP\u8ba1\u5212\u5bfc\u5165\uff0c\u51c6\u5907\u597d\u7684\u6570\u636e:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr(dataToSave), (Object)JSONUtil.toJsonStr(errMsgMap));
        this.transactionTemplate.setPropagationBehavior(3);
        for (ScpMrpDImportSaveVO vo : dataToSave) {
            this.transactionTemplate.execute(transactionStatus -> {
                try {
                    this.scpMrpDDomainService.updateNetDemand(vo.getId(), vo.getNetDemand());
                    this.scpMrpDPlanDomainService.deleteByMasIds(List.of(vo.getId()));
                    this.scpMrpDPlanDomainService.save(vo.getScpMrpDPlanSaveVOList());
                }
                catch (Exception e) {
                    log.error("MRP\u8ba1\u5212\u5bfc\u5165\u62a5\u9519\uff1a" + e);
                    transactionStatus.setRollbackOnly();
                }
                return null;
            });
        }
        long docNumber = dataList.stream().map(ScpMrpDImportEntity::getId).distinct().count();
        String orderMsg = String.format("\u6587\u4ef6\u5171\u5305\u542b%d\u6761\u6570\u636e\uff0c\u8bc6\u522b\u51fa\u8ba2\u8d27\u5355%d\u5355\uff0c\u5176\u4e2d\u5bfc\u5165\u6210\u529f%d\u5355\uff0c\u5931\u8d25%d\u5355", dataList.size(), docNumber, docNumber - (long)errorIdSet.size(), errorIdSet.size());
        log.info("\u5199\u5165\u81ea\u5b9a\u4e49\u63d0\u793a\u8bed:{}", (Object)orderMsg);
        HttpServletUtil.currentRequest().setAttribute("orderMsg", (Object)orderMsg);
        return new ArrayList<String>(errMsgMap.values());
    }

    private List<ScpMrpDImportSaveVO> prepareData(List<ScpMrpDImportEntity> dataList, Map<Integer, String> errMsgMap, Set<Long> errorIdSet) {
        ArrayList<ScpMrpDImportSaveVO> resultList = new ArrayList<ScpMrpDImportSaveVO>();
        Map<Long, List<ScpMrpDImportEntity>> idMap = dataList.stream().collect(Collectors.groupingBy(ScpMrpDImportEntity::getId));
        List<Long> mrpDIds = dataList.stream().collect(Collectors.groupingBy(ScpMrpDImportEntity::getId)).keySet().stream().distinct().collect(Collectors.toList());
        List<ScpMrpDRespVO> scpMrpDRespVOList = this.scpMrpDDomainService.findByIds(mrpDIds);
        if (CollUtil.isEmpty(scpMrpDRespVOList)) {
            ScpMrpDImportService.addErrMsg(errMsgMap, dataList.stream().map(ScpMrpDImportEntity::getRowNo).collect(Collectors.toList()), "MRP\u8ba1\u5212\u660e\u7ec6\u4e0d\u5b58\u5728");
            errorIdSet.addAll(dataList.stream().map(ScpMrpDImportEntity::getId).collect(Collectors.toList()));
            return null;
        }
        Map<Long, ScpMrpDRespVO> mrpDMap = scpMrpDRespVOList.stream().collect(Collectors.toMap(BaseViewModel::getId, d -> d));
        List purOuCodes = dataList.stream().map(ScpMrpDImportEntity::getPurOuCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        List suppCodes = dataList.stream().map(ScpMrpDImportEntity::getSuppCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.orgOuRpcService.findSimpleByOuCodes(purOuCodes).stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, o -> o));
        PurSuppBaseRpcParam suppParam = new PurSuppBaseRpcParam();
        suppParam.setSuppCodes(suppCodes);
        ApiResult suppResult = this.purSuppProvider.findSimpleRpcDtoByParam(suppParam);
        Map<Object, Object> suppMap = new HashMap();
        if (suppResult.isSuccess() && CollectionUtil.isNotEmpty((Collection)((Collection)suppResult.getData()))) {
            suppMap = ((List)suppResult.getData()).stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getSuppCode, s -> s));
        }
        for (Map.Entry<Long, List<ScpMrpDImportEntity>> entry : idMap.entrySet()) {
            ScpMrpDImportSaveVO scpMrpDImportSaveVO = new ScpMrpDImportSaveVO();
            List<ScpMrpDImportEntity> itemList = entry.getValue();
            ScpMrpDImportEntity header = itemList.get(0);
            List<Integer> rowNoList = itemList.stream().map(ScpMrpDImportEntity::getRowNo).collect(Collectors.toList());
            ScpMrpDRespVO scpMrpDRespVO = mrpDMap.get(header.getId());
            if (scpMrpDRespVO == null) {
                ScpMrpDImportService.addErrMsg(errMsgMap, rowNoList, "MRP\u8ba1\u5212\u660e\u7ec6\u4e0d\u5b58\u5728");
                errorIdSet.add(entry.getKey());
                continue;
            }
            if (header.getNetDemand() == null || header.getNetDemand().compareTo(BigDecimal.ZERO) <= 0) {
                ScpMrpDImportService.addErrMsg(errMsgMap, rowNoList, "\u51c0\u9700\u6c42\u4e3a\u7a7a\u6216\u5c0f\u4e8e\u7b49\u4e8e0");
                errorIdSet.add(entry.getKey());
                continue;
            }
            BigDecimal sumPurQty = itemList.stream().map(ScpMrpDImportEntity::getPurQty).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (sumPurQty.compareTo(header.getNetDemand()) != 0) {
                ScpMrpDImportService.addErrMsg(errMsgMap, rowNoList, "\u91c7\u8d2d\u8ba1\u5212\u6570\u91cf\u4e4b\u548c\u4e0d\u7b49\u4e8e\u51c0\u9700\u6c42");
                errorIdSet.add(entry.getKey());
                continue;
            }
            scpMrpDImportSaveVO.setId(header.getId());
            scpMrpDImportSaveVO.setNetDemand(header.getNetDemand());
            Map<Object, Object> finalSuppMap = suppMap;
            ArrayList<ScpMrpDPlanSaveVO> planList = new ArrayList<ScpMrpDPlanSaveVO>();
            itemList.forEach(row -> {
                ScpMrpDPlanSaveVO scpMrpDPlanSaveVO = new ScpMrpDPlanSaveVO();
                scpMrpDPlanSaveVO.setMasId(header.getId());
                if (CollectionUtil.isNotEmpty((Map)ouMap) && StringUtils.isNotBlank((CharSequence)row.getPurOuCode()) && ouMap.containsKey(row.getPurOuCode())) {
                    OrgOuRpcSimpleDTO ouDTO = (OrgOuRpcSimpleDTO)ouMap.get(row.getPurOuCode());
                    scpMrpDPlanSaveVO.setOuCode(ouDTO.getOuCode());
                    scpMrpDPlanSaveVO.setOuName(ouDTO.getOuName());
                } else {
                    ScpMrpDImportService.addErrMsg(errMsgMap, row.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, row.getRowNo(), "\u91c7\u8d2d\u516c\u53f8", "\u91c7\u8d2d\u516c\u53f8\u7f16\u7801:\u91c7\u8d2d\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728"));
                    errorIdSet.add((Long)entry.getKey());
                }
                if (CollectionUtil.isNotEmpty((Map)finalSuppMap) && StringUtils.isNotBlank((CharSequence)row.getSuppCode()) && finalSuppMap.containsKey(row.getSuppCode())) {
                    PurSuppBaseRpcDTO suppDTO = (PurSuppBaseRpcDTO)finalSuppMap.get(row.getSuppCode());
                    scpMrpDPlanSaveVO.setSuppCode(suppDTO.getSuppCode());
                    scpMrpDPlanSaveVO.setSuppName(suppDTO.getSuppName());
                } else {
                    ScpMrpDImportService.addErrMsg(errMsgMap, row.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, row.getRowNo(), "\u4f9b\u5e94\u5546", "\u4f9b\u5e94\u5546\u7f16\u7801:\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728"));
                    errorIdSet.add((Long)entry.getKey());
                }
                if (row.getPurQty() != null && row.getPurQty().compareTo(BigDecimal.ZERO) > 0) {
                    scpMrpDPlanSaveVO.setQty(row.getPurQty());
                } else {
                    ScpMrpDImportService.addErrMsg(errMsgMap, row.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, row.getRowNo(), "\u91c7\u8d2d\u8ba1\u5212\u6570\u91cf", "\u91c7\u8d2d\u8ba1\u5212\u6570\u91cf:\u91c7\u8d2d\u8ba1\u5212\u6570\u91cf\u4e0d\u5b58\u5728\u6216\u5c0f\u4e8e\u7b49\u4e8e0"));
                    errorIdSet.add((Long)entry.getKey());
                }
                scpMrpDPlanSaveVO.setPushStatus(ScpUdcEnum.MRP_D_PUSH_STATUS_NOT.getValueCode());
                planList.add(scpMrpDPlanSaveVO);
            });
            scpMrpDImportSaveVO.setScpMrpDPlanSaveVOList(planList);
            resultList.add(scpMrpDImportSaveVO);
        }
        return resultList;
    }

    public static void addErrMsg(Map<Integer, String> errMsgMap, Integer rowNo, String msg) {
        ScpMrpDImportService.addErrMsg(errMsgMap, Collections.singletonList(rowNo), msg);
    }

    public static void addErrMsg(Map<Integer, String> errMsgMap, List<Integer> rowNos, String msg) {
        for (Integer rowNo : rowNos) {
            if (errMsgMap.containsKey(rowNo) && errMsgMap.get(rowNo) != null) {
                String newMsg = errMsgMap.get(rowNo) + LINE + msg;
                errMsgMap.put(rowNo, newMsg);
                continue;
            }
            errMsgMap.put(rowNo, msg);
        }
    }

    public ScpMrpDImportService(TransactionTemplate transactionTemplate, ScpMrpDDomainService scpMrpDDomainService, ScpMrpDPlanDomainService scpMrpDPlanDomainService, OrgOuRpcService orgOuRpcService, PurSuppProvider purSuppProvider) {
        this.transactionTemplate = transactionTemplate;
        this.scpMrpDDomainService = scpMrpDDomainService;
        this.scpMrpDPlanDomainService = scpMrpDPlanDomainService;
        this.orgOuRpcService = orgOuRpcService;
        this.purSuppProvider = purSuppProvider;
    }
}

