/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.feedback.impl;

import com.alibaba.fastjson.JSONObject;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackQueryParamVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackRespVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackSaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.feedback.ScpStoreFeedbackConvert;
import com.elitesland.scp.domain.entity.feedback.QScpStoreFeedbackDO;
import com.elitesland.scp.domain.entity.feedback.ScpStoreFeedbackDO;
import com.elitesland.scp.domain.service.feedback.ScpStoreFeedbackDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.feedback.ScpStoreFeedbackRepo;
import com.elitesland.scp.infr.repo.feedback.ScpStoreFeedbackRepoProc;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.github.houbb.sensitive.word.bs.SensitiveWordBs;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="scpStoreFeedbackDomainService")
public class ScpStoreFeedbackDomainServiceImpl
implements ScpStoreFeedbackDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreFeedbackDomainServiceImpl.class);
    private final ScpStoreFeedbackRepo scpStoreFeedbackRepo;
    private final ScpStoreFeedbackRepoProc scpStoreFeedbackRepoProc;
    private final SensitiveWordBs sensitiveWordBs;
    private final FileService fileService;

    @Override
    public PagingVO<ScpStoreFeedbackRespVO> search(ScpStoreFeedbackQueryParamVO param) {
        Page ret = this.scpStoreFeedbackRepo.findAll(this.scpStoreFeedbackRepoProc.where(param), (Pageable)param.getPageRequest());
        List<ScpStoreFeedbackRespVO> vos = ret.getContent().stream().map(ScpStoreFeedbackConvert.INSTANCE::doToVO).collect(Collectors.toList());
        vos.forEach(item -> {
            if (item.getFileUrl() != null) {
                item.setFileUrlList(JSONObject.parseArray((String)item.getFileUrl(), ScpStoreFeedbackRespVO.FileObject.class));
            }
            String replace = this.sensitiveWordBs.replace(item.getEvaluationComment());
            item.setEvaluationComment(replace);
            String replace1 = this.sensitiveWordBs.replace(item.getOptimizationSuggestion());
            item.setOptimizationSuggestion(replace1);
        });
        return PagingVO.builder().total(ret.getTotalElements()).records(vos).build();
    }

    @Override
    public void exportZip(ScpStoreFeedbackQueryParamVO param, HttpServletRequest request, HttpServletResponse response) {
        Path tempDir = null;
        FileInputStream inputStream = null;
        ServletOutputStream out = null;
        try {
            int bytesRead;
            tempDir = Files.createTempDirectory("feedback_files_", new FileAttribute[0]);
            Page ret = this.scpStoreFeedbackRepo.findAll(this.scpStoreFeedbackRepoProc.where(param), (Pageable)param.getPageRequest());
            List<ScpStoreFeedbackRespVO> vos = ret.getContent().stream().map(ScpStoreFeedbackConvert.INSTANCE::doToVO).collect(Collectors.toList());
            ArrayList downloadFiles = new ArrayList();
            vos.forEach(item -> {
                if (item.getFileUrl() != null) {
                    item.setFileUrlList(JSONObject.parseArray((String)item.getFileUrl(), ScpStoreFeedbackRespVO.FileObject.class));
                    item.getFileUrlList().forEach(fileObj -> {
                        DownloadFileInfo downloadFileInfo = new DownloadFileInfo();
                        downloadFileInfo.setFileCode(fileObj.getFileCode());
                        downloadFileInfo.setFileName((item.getDcoNo() == null ? "" : item.getDcoNo()) + "-" + fileObj.getFileCode());
                        downloadFileInfo.setFileUrl(fileObj.getFileUrl());
                        downloadFiles.add(downloadFileInfo);
                    });
                }
            });
            Path finalTempDir = tempDir;
            List<Path> downloadedFiles = downloadFiles.stream().map(fileInfo -> this.downloadFileToTemp((DownloadFileInfo)fileInfo, finalTempDir)).filter(Objects::nonNull).collect(Collectors.toList());
            String zipFileName = "\u95e8\u5e97\u53cd\u9988\u56fe\u7247\u89c6\u9891" + System.currentTimeMillis() + ".zip";
            Path zipFilePath = tempDir.resolve(zipFileName);
            this.createZipFile(downloadedFiles, zipFilePath);
            response.setContentType("application/zip");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(zipFileName, "UTF-8"));
            inputStream = new FileInputStream(zipFilePath.toFile());
            out = response.getOutputStream();
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
        catch (IOException e) {
            log.error("\u521b\u5efa ZIP \u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, "\u6587\u4ef6\u6253\u5305\u5931\u8d25: " + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.warn("\u5173\u95ed\u8f93\u5165\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.warn("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
            this.cleanupTempDirectory(tempDir);
        }
    }

    private void cleanupTempDirectory(Path tempDir) {
        if (tempDir != null) {
            try {
                Files.walk(tempDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                log.warn("\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private Path downloadFileToTemp(DownloadFileInfo fileInfo, Path tempDir) {
        Path filePath = null;
        try {
            String fileName = fileInfo.getFileName();
            String[] split = fileInfo.getFileUrl().split("\\.");
            filePath = tempDir.resolve(fileName + "." + split[split.length - 1]);
            try (InputStream in = new URL(fileInfo.getFileUrl()).openStream();){
                Files.copy(in, filePath, StandardCopyOption.REPLACE_EXISTING);
            }
            return filePath;
        }
        catch (MalformedURLException e) {
            log.warn("\u65e0\u6548\u7684\u6587\u4ef6URL: {}", (Object)fileInfo.getFileUrl(), (Object)e);
            if (filePath != null) {
                try {
                    Files.deleteIfExists(filePath);
                }
                catch (IOException deleteEx) {
                    log.warn("\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u5931\u8d25: {}", filePath, (Object)deleteEx);
                }
            }
            return null;
        }
        catch (IOException e) {
            log.warn("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25: {}", (Object)fileInfo.getFileName(), (Object)e);
            if (filePath != null) {
                try {
                    Files.deleteIfExists(filePath);
                }
                catch (IOException deleteEx) {
                    log.warn("\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u5931\u8d25: {}", filePath, (Object)deleteEx);
                }
            }
            return null;
        }
    }

    private void createZipFile(List<Path> files, Path zipFilePath) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zipFilePath, new OpenOption[0]));){
            byte[] buffer = new byte[1024];
            for (Path file : files) {
                if (!Files.exists(file, new LinkOption[0])) continue;
                ZipEntry zipEntry = new ZipEntry(file.getFileName().toString());
                zos.putNextEntry(zipEntry);
                try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
                    int length;
                    while ((length = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, length);
                    }
                }
                zos.closeEntry();
            }
        }
    }

    @Override
    public Optional<ScpStoreFeedbackRespVO> findCodeOne(String itemCode) {
        JPAQuery<ScpStoreFeedbackRespVO> jpaQuery = this.scpStoreFeedbackRepoProc.select(null);
        QScpStoreFeedbackDO jpaQDo = QScpStoreFeedbackDO.scpStoreFeedbackDO;
        ScpStoreFeedbackRespVO vo = (ScpStoreFeedbackRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @Override
    public Optional<ScpStoreFeedbackRespVO> findIdOne(Long id) {
        return this.scpStoreFeedbackRepo.findById(id).map(ScpStoreFeedbackConvert.INSTANCE::doToVO);
    }

    @Override
    public List<ScpStoreFeedbackRespVO> findIdBatch(List<Long> idList) {
        return this.scpStoreFeedbackRepo.findAllById(idList).stream().map(ScpStoreFeedbackConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public Long createOne(ScpStoreFeedbackSaveVO param) {
        ScpStoreFeedbackDO objDo = ScpStoreFeedbackConvert.INSTANCE.saveParamToDo(param);
        if (param.getId() != null && param.getId() > 0L) {
            Optional optional = this.scpStoreFeedbackRepo.findById(objDo.getId());
            if (optional.isPresent()) {
                BeanCopyUtil.beanCopyWithIngore((Object)objDo, (Object)((ScpStoreFeedbackDO)optional.get()), (String[])BeanCopyUtil.getNullPropertyNames((Object)objDo));
                this.scpStoreFeedbackRepo.save((ScpStoreFeedbackDO)optional.get());
            } else {
                throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
            }
        }
        return ((ScpStoreFeedbackDO)this.scpStoreFeedbackRepo.save(objDo)).getId();
    }

    @Override
    @Transactional
    public List<ScpStoreFeedbackRespVO> createBatch(List<ScpStoreFeedbackSaveVO> list) {
        List dos = list.stream().map(ScpStoreFeedbackConvert.INSTANCE::creatParamToDo).collect(Collectors.toList());
        return this.scpStoreFeedbackRepo.saveAll(dos).stream().map(ScpStoreFeedbackConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> statusChangeByProcess(long id, ProcInstStatus procInstStatus, String approveComment) {
        log.info("\u95e8\u5e97\u53cd\u9988\u5de5\u4f5c\u6d41\u56de\u8c03:{},{}", (Object)id, (Object)procInstStatus);
        Optional<ScpStoreFeedbackRespVO> optional = this.findIdOne(id);
        if (optional.isEmpty()) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        ScpStoreFeedbackRespVO scpStoreFeedbackRespVO = optional.get();
        HashMap<String, String> result = new HashMap<String, String>();
        scpStoreFeedbackRespVO.setProcInstStatus(procInstStatus);
        String docStatus = null;
        String approveStatus = null;
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        switch (procInstStatus) {
            case NOTSUBMIT: 
            case INTERRUPT: {
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_DRAFT.getValueCode();
                break;
            }
            case REJECTED: {
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_DONE.getValueCode();
                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_INVALID.getValueCode();
                break;
            }
            case INVALID: {
                break;
            }
            case APPROVING: {
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_APPROVING.getValueCode();
                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_APPROVING.getValueCode();
                break;
            }
            case APPROVED: {
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_DONE.getValueCode();
                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_VALID.getValueCode();
                scpStoreFeedbackRespVO.setApprovalTime(LocalDateTime.now());
                if (currentUserDTO == null) break;
                scpStoreFeedbackRespVO.setApprovedBy(currentUserDTO.getDetail().getLastName());
                break;
            }
            default: {
                throw new IllegalStateException("\u975e\u6cd5\u8bbf\u95ee");
            }
        }
        scpStoreFeedbackRespVO.setFeedbackStatus(docStatus);
        scpStoreFeedbackRespVO.setApprovalStatus(approveStatus);
        scpStoreFeedbackRespVO.setProcInstStatus(procInstStatus);
        scpStoreFeedbackRespVO.setRemark(approveComment);
        this.updateById(scpStoreFeedbackRespVO);
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            // empty if block
        }
        return result;
    }

    @Override
    @Transactional
    public void updateById(ScpStoreFeedbackRespVO param) {
        this.scpStoreFeedbackRepoProc.update(param);
    }

    @Override
    @Transactional
    public void update(ScpStoreFeedbackSaveVO param) {
        ScpStoreFeedbackDO objDo = ScpStoreFeedbackConvert.INSTANCE.saveParamToDo(param);
        Optional optional = this.scpStoreFeedbackRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore((Object)objDo, (Object)((ScpStoreFeedbackDO)optional.get()), (String[])BeanCopyUtil.getNullPropertyNames((Object)objDo));
        this.scpStoreFeedbackRepo.save((ScpStoreFeedbackDO)optional.get());
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        QScpStoreFeedbackDO jpaQDo = QScpStoreFeedbackDO.scpStoreFeedbackDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.scpStoreFeedbackRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        ScpStoreFeedbackDO do1 = (ScpStoreFeedbackDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.scpStoreFeedbackRepo.save(do1);
    }

    @Override
    @Transactional
    public void deleteOne(Long id) {
        this.scpStoreFeedbackRepo.deleteById(id);
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.scpStoreFeedbackRepo.deleteById(id));
    }

    public ScpStoreFeedbackDomainServiceImpl(ScpStoreFeedbackRepo scpStoreFeedbackRepo, ScpStoreFeedbackRepoProc scpStoreFeedbackRepoProc, SensitiveWordBs sensitiveWordBs, FileService fileService) {
        this.scpStoreFeedbackRepo = scpStoreFeedbackRepo;
        this.scpStoreFeedbackRepoProc = scpStoreFeedbackRepoProc;
        this.sensitiveWordBs = sensitiveWordBs;
        this.fileService = fileService;
    }

    private static class DownloadFileInfo {
        private String fileName;
        private String fileUrl;
        private String fileCode;

        public String getFileName() {
            return this.fileName;
        }

        public String getFileUrl() {
            return this.fileUrl;
        }

        public String getFileCode() {
            return this.fileCode;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setFileUrl(String fileUrl) {
            this.fileUrl = fileUrl;
        }

        public void setFileCode(String fileCode) {
            this.fileCode = fileCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DownloadFileInfo)) {
                return false;
            }
            DownloadFileInfo other = (DownloadFileInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            String this$fileUrl = this.getFileUrl();
            String other$fileUrl = other.getFileUrl();
            if (this$fileUrl == null ? other$fileUrl != null : !this$fileUrl.equals(other$fileUrl)) {
                return false;
            }
            String this$fileCode = this.getFileCode();
            String other$fileCode = other.getFileCode();
            return !(this$fileCode == null ? other$fileCode != null : !this$fileCode.equals(other$fileCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DownloadFileInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            String $fileUrl = this.getFileUrl();
            result = result * 59 + ($fileUrl == null ? 43 : $fileUrl.hashCode());
            String $fileCode = this.getFileCode();
            result = result * 59 + ($fileCode == null ? 43 : $fileCode.hashCode());
            return result;
        }

        public String toString() {
            return "ScpStoreFeedbackDomainServiceImpl.DownloadFileInfo(fileName=" + this.getFileName() + ", fileUrl=" + this.getFileUrl() + ", fileCode=" + this.getFileCode() + ")";
        }
    }
}

