package com.elitesland.scp.application.facade.vo.feedback;


import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel(value = "ScpStoreFeedbackQueryParamVO", description = "门店反馈")
public class ScpStoreFeedbackQueryParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 200354822298124697L;
    /**
    * 主键
    */    
    @ApiModelProperty("主键")
    private Long id;
    /**
    * 反馈类型
    */    
    @ApiModelProperty("反馈类型")
    private String feedbackType;
    /**
    * 反馈原因
    */    
    @ApiModelProperty("反馈原因")
    private String feedbackReason;
    /**
    * 反馈门店编码
    */    
    @ApiModelProperty("反馈门店编码")
    private String feedbackStoreCode;
    /**
    * 反馈门店名称
    */    
    @ApiModelProperty("反馈门店名称")
    private String feedbackStoreName;

    @ApiModelProperty("反馈状态")
    private String feedbackStatus;

    @ApiModelProperty("过滤掉的反馈状态")
    private String filteredFeedbackStatus;
    /**
    * 商品编码
    */    
    @ApiModelProperty("商品编码")
    private String itemCode;
    /**
    * 商品名称
    */    
    @ApiModelProperty("商品名称")
    private String itemName;
    /**
    * 反馈评分
    */    
    @ApiModelProperty("反馈评分")
    private BigDecimal feedbackScore;
    /**
    * 评价意见
    */    
    @ApiModelProperty("评价意见")
    private String evaluationComment;
    /**
    * 优化意见
    */    
    @ApiModelProperty("优化意见")
    private String optimizationSuggestion;
    /**
    * 图片编码
    */    
    @ApiModelProperty("图片编码")
    private String fileCode;
    /**
    * 图片url
    */    
    @ApiModelProperty("图片url")
    private String fileUrl;
    /**
    * 审批状态
    */    
    @ApiModelProperty("审批状态")
    private String approvalStatus;
    /**
    * 反馈时间
    */    
    @ApiModelProperty("反馈时间")
    private LocalDateTime feedbackTime;
    /**
    * 反馈人
    */    
    @ApiModelProperty("反馈人")
    private String feedbackBy;
    /**
    * 审批人
    */    
    @ApiModelProperty("审批人")
    private String approvedBy;
    /**
    * 审批时间
    */    
    @ApiModelProperty("审批时间")
    private LocalDateTime approvalTime;

    @ApiModelProperty("物料类型")
    private String itemType2;
    /**
    * 租户ID
    */    
    @ApiModelProperty("租户ID")
    private Long tenantId;
    /**
    * 备注
    */    
    @ApiModelProperty("备注")
    private String remark;
    /**
    * 记录创建者ID
    */    
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
    * 记录创建者
    */    
    @ApiModelProperty("记录创建者")
    private String creator;
    /**
    * 记录创建时间
    */    
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTimeStart;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTimeEnd;
    /**
    * 记录最后更新者ID
    */    
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
    * 记录最后更新者
    */    
    @ApiModelProperty("记录最后更新者")
    private String updater;
    /**
    * 记录最后更新时间
    */    
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
    * 记录最后更新时间
    */    
    @ApiModelProperty("记录最后更新时间")
    private Integer deleteFlag;
    /**
    * 锁版本
    */    
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;
    /**
    * 数据归属组织id
    */    
    @ApiModelProperty("数据归属组织id")
    private Long secBuId;
    /**
    * 数据归属雇员id
    */    
    @ApiModelProperty("数据归属雇员id")
    private Long secUserId;
    /**
    * 数据归属公司id
    */    
    @ApiModelProperty("数据归属公司id")
    private Long secOuId;
    /**
    * 所属组织ID
    */    
    @ApiModelProperty("所属组织ID")
    private Long belongOrgId;
    /**
    * 租户组织ID
    */    
    @ApiModelProperty("租户组织ID")
    private Long tenantOrgId;


}
