package com.elitesland.scp.application.facade.vo.param.order;

import com.elitesland.scp.common.PartitionQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;

@Data
@ApiModel(value = "订货集分页查询参数")
@ToString(callSuper = true)
public class ScpOrderTemplatePageParamVO extends PartitionQueryParam implements Serializable {
    @ApiModelProperty("模板类型")
    private String type;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("应用门店代码")
    private String storeCode;

    @ApiModelProperty("应用门店名称")
    private String storeName;

    @ApiModelProperty("所属区域")
    private String regionCode;

    @ApiModelProperty("订单截至时间点")
    private LocalTime deadlineTime;

    @ApiModelProperty("开始日期")
    private LocalDate startDate;

    @ApiModelProperty("结束日期")
    private LocalDate endDate;

    @ApiModelProperty("日期")
    private LocalDate date;

    @ApiModelProperty("是否启用")
    private Integer isActive;

}
