package com.elitesland.scp.application.facade.vo.resp.app;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel("支付订单详情")
public class AppPayOrderRespVO implements Serializable {
    private static final long serialVersionUID = 8625377458211198658L;

    @ApiModelProperty("关联单据号")
    private String srcDocNo;

    @ApiModelProperty("关联单据类别")
    private String srcDocCls;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;

    @ApiModelProperty("订货单编码")
    private String docCode;
    @ApiModelProperty("订货单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long docId;

    @ApiModelProperty("销售方编码")
    private String saleOuCode;

    @ApiModelProperty("销售方名称")
    private String saleOuName;

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("付款状态")
    @SysCode(sys = "yst-suplan", mod = "PAY_STATUS")
    private String payStatus;
    private String payStatusName;

    @ApiModelProperty("收货地址号")
    private Long recvAddrNo;

    @ApiModelProperty("收货联系人")
    private String recvContactName;

    @ApiModelProperty("收货联系电话")
    private String recvContactTel;

    @ApiModelProperty("收货国家")
    private String recvCountry;

    @ApiModelProperty("收货省")
    private String recvProvince;

    @ApiModelProperty("收货市")
    private String recvCity;

    @ApiModelProperty("收货区县")
    private String recvCounty;

    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    @ApiModelProperty("收货国家名称")
    private String recvCountryName;

    @ApiModelProperty("收货省名称")
    private String recvProvinceName;

    @ApiModelProperty("收货市名称")
    private String recvCityName;

    @ApiModelProperty("收货区县名称")
    private String recvCountyName;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("倒计时")
    private String countdown;

    @ApiModelProperty("在线支付标识")
    private Boolean onlinePayFlag;

    @ApiModelProperty("付款人")
    private String payerName;
}
