package com.elitesland.scp.application.facade.vo.resp.order;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

@Data
@ApiModel("订货订单明细返回")
public class ScpDemandOrderDRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -4099575500015071676L;

    @ApiModelProperty("订货订单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("原始id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long sourceId;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty("SPU商品编码")
    @NotNull(message = "SPU商品编码不能为空")
    private String spuItemCode;

    @ApiModelProperty("SPU商品名称")
    private String spuItemName;

    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品分类")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("商品别名")
    private String anotherName;

    @ApiModelProperty("箱规")
    private String itemAttrName;

    @ApiModelProperty("skuItems")
    private List<ScpDemandOrderDRespVO> skuItems;

    @ApiModelProperty("需求数量")
    private BigDecimal demandQuantity;

    @ApiModelProperty("拆分需求数量")
    private BigDecimal allocationDeQuantity;

    @ApiModelProperty("订货单位")
    private String unit;

    @ApiModelProperty("订货单位")
    private String unitName;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("币种，默认CNY")
    private String currency;

    @ApiModelProperty("分配数量")
    private BigDecimal allocationQuantity;

    @ApiModelProperty("供应类型，WH:仓库，SUPP:供应商")
    @SysCode(sys = "yst-suplan", mod = "SUPPLY_DEMAND_TYPE")
    private String supplyType;
    private String supplyTypeName;

    @ApiModelProperty("供应仓库id、供应商id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppWhId;

    @ApiModelProperty("供应仓库编码、供应商编码")
    private String suppWhCode;

    @ApiModelProperty("供应仓库名称、供应商名称")
    private String suppWhName;

    @ApiModelProperty("采购公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("采购公司编码")
    private String ouCode;

    @ApiModelProperty("采购公司名称")
    private String ouName;

    @ApiModelProperty("分配单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;

    @ApiModelProperty("分配单据编码")
    private String srcDocNo;

    @ApiModelProperty("分配单据类别")
    private String srcDocCls;

    @ApiModelProperty("分配单据明细行号")
    private String srcDocLineNo;

    @ApiModelProperty("发货数量")
    private BigDecimal quantity;

    @ApiModelProperty("供应仓库/供应商份额")
    private BigDecimal ratio;

    @ApiModelProperty("计划数量")
    private BigDecimal planQuantity;

    @ApiModelProperty("是否已计算，true:已计算，false:未计算")
    private Boolean isCalculated;
    private String isCalculatedName;

    @ApiModelProperty("是否已推送, true:已推送，false:未推送")
    private Boolean isPushed;
    private String isPushedName;

    @ApiModelProperty("推送订单信息")
    private String syncMsg;

    @ApiModelProperty("基本单位数量")
    private BigDecimal qty2;

    @ApiModelProperty("基本单位")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty("单位转换系数")
    private BigDecimal uomRatio;

    @ApiModelProperty(name = "有效小数位数")
    private Integer decimalPlaces;

    @ApiModelProperty("运费是否需要计费")
    private Boolean freightFlag;

    @ApiModelProperty("运费比例")
    private BigDecimal freightRatio;

    @ApiModelProperty("运费金额")
    private BigDecimal freightAmt;


    @ApiModelProperty("销售公司编码")
    private String saleOuCode;

    @ApiModelProperty("销售公司名称")
    private String saleOuName;

    @ApiModelProperty("销售客户编码")
    private String saleCustCode;

    @ApiModelProperty(value = "含税金额")
    private BigDecimal planAmt;

    @ApiModelProperty(value = "商品图片")
    private String imgUrl;

    @ApiModelProperty(value = "商品图片")
    private String url;

    @ApiModelProperty("最小强配数量")
    private BigDecimal minNum;

    @ApiModelProperty("强配活动ID")
    private Long activityId;

    @ApiModelProperty("强配活动编码")
    private String activityCode;

    @ApiModelProperty("组合品编码")
    private String combineItemCode;

    @ApiModelProperty("子品集合")
    private List<ScpDemandOrderDRespVO> subItems;

    public Long fetchImageId() {
        if (Objects.equals(itemCode, spuItemCode)) {
            return spuId;
        }
        return itemId;
    }

    public String getIsCalculatedName() {
        return (isCalculated != null && isCalculated) ? "已计算" : "未计算";
    }

    public String getIsPushedName() {
        return (isPushed != null && isPushed) ? "已推送" : "未推送";
    }


}
