package com.elitesland.scp.application.service.boh.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.threadpool.ThreadPoolAutoConfiguration;
import com.elitesland.scp.application.facade.vo.boh.*;
import com.elitesland.scp.application.facade.vo.template.DemandOrderListParamVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderListRespVO;
import com.elitesland.scp.application.service.boh.StoreAppletService;
import com.elitesland.scp.application.service.template.DemandOrderTemplateService;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepoProc;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@Service
@Slf4j
@RequiredArgsConstructor
public class StoreAppletServiceImpl implements StoreAppletService {

    @Autowired
    @Qualifier(ThreadPoolAutoConfiguration.BEAN_NAME)
    private TaskExecutor taskExecutor;
    private final StoreReceiveRepoProc storeReceiveRepoProc;
    private final ItmItemRpcService itmItemRpcService;
    private final DemandOrderTemplateService demandOrderTemplateService;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;

    @Override
    public StoreAppletHomeVO find(Long storeId, LocalDateTime startDate, String demandWhStCode, String type) {
        StoreAppletHomeVO storeAppletHomeVO = new StoreAppletHomeVO();

        CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> {
            storeAppletHomeVO.setReceiveCount(storeReceiveRepoProc.findReceive(storeId, startDate));
            storeAppletHomeVO.setReplyCount(scpDemandOrderRepoProc.countUnReply(storeId, startDate));
        }, taskExecutor);

        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> {
            storeAppletHomeVO.setRtnCount(storeReceiveRepoProc.findRtn(storeId, startDate));
            storeAppletHomeVO.setOrderCount(storeReceiveRepoProc.findOrderCount(storeId, startDate));
            storeAppletHomeVO.setOrderCalendar(storeReceiveRepoProc.storeCalendar(storeId));
        }, taskExecutor);

        CompletableFuture.allOf(future1, future2).join();

        return storeAppletHomeVO;
    }

    private int templateCount(String demandWhStCode, String type) {
        DemandOrderListParamVO vo = new DemandOrderListParamVO();
        vo.setDemandWhStCode(demandWhStCode);
        vo.setType(type);
        List<DemandOrderListRespVO> list = demandOrderTemplateService.list(vo);
        if (CollUtil.isEmpty(list)) {
            return 0;
        } else {
            return list.size();
        }
    }

    @Override
    public StoreTodoVO todo(StoreReceivePageParam param) {
        List<Long> docIds = findDocIds(param);
        if (docIds != null && docIds.isEmpty()) {
            return new StoreTodoVO();
        }
        return storeReceiveRepoProc.findTodo(param);
    }

    private List<Long> findDocIds(StoreReceivePageParam param) {
        if (StrUtil.isNotBlank(param.getItemName()) || StrUtil.isNotBlank(param.getItemCode()) || StrUtil.isNotBlank(param.getItemKeyword())) {
            List<Long> itemIdByCodeName = itmItemRpcService.findItemIdByCodeName(param.getItemCode(),
                    param.getItemName(), param.getItemKeyword());
            if (CollectionUtil.isEmpty(itemIdByCodeName)) {
                return new ArrayList<>();
            }

            if (CollectionUtil.isEmpty(param.getItemIds())) {
                param.setItemIds(itemIdByCodeName);
            } else {
                param.getItemIds().retainAll(itemIdByCodeName);
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                return new ArrayList<>();
            }
        }

        if (CollectionUtil.isNotEmpty(param.getCateIds())) {
            List<Long> allLeafCateId = itmItemRpcService.findAllLeafCateId(param.getCateIds());
            param.setCateIds(allLeafCateId);

            List<Long> itemIdsByCate = storeReceiveRepoProc.findItemIdsByCate(allLeafCateId);
            if (CollectionUtil.isEmpty(itemIdsByCate)) {
                return new ArrayList<>();
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                param.setItemIds(itemIdsByCate);
            } else {
                param.getItemIds().retainAll(itemIdsByCate);
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                return new ArrayList<>();
            }
        }

        if (CollectionUtil.isNotEmpty(param.getItemIds())) {
            List<Long> docId = storeReceiveRepoProc.findDocId(param.getItemIds());
            if (CollectionUtil.isEmpty(docId)) {
                return new ArrayList<>();
            }
            if (CollectionUtil.isEmpty(param.getIds())) {
                param.setIds(docId);
            } else {
                param.getIds().retainAll(docId);
            }
            if (CollectionUtil.isEmpty(param.getIds())) {
                return new ArrayList<>();
            }

            return param.getIds();
        }
        return null;
    }

    @Override
    public StoreReceiveTotalVO receiveTotal(StoreReceivePageParam param) {
        List<Long> docIds = findDocIds(param);
        if (docIds != null && docIds.isEmpty()) {
            return new StoreReceiveTotalVO();
        }
        return storeReceiveRepoProc.findReceiveTotal(param);
    }

    @Override
    public StoreRtnTotalVO rtnCount(StoreReceivePageParam param) {
        List<Long> docIds = findDocIds(param);
        if (docIds != null && docIds.isEmpty()) {
            return new StoreRtnTotalVO();
        }
        return storeReceiveRepoProc.findRtnTotal(param);
    }
}
