package com.elitesland.scp.application.service.feedback;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackApproveVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackQueryParamVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackRespVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackSaveVO;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author makejava
 * @since 2025-09-23 18:08:00
 */
public interface ScpStoreFeedbackService {
 /**
     * 检索 
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<ScpStoreFeedbackRespVO> search(ScpStoreFeedbackQueryParamVO queryParam);

    PagingVO<ScpStoreFeedbackRespVO> searchByPc(ScpStoreFeedbackQueryParamVO param);

    void exportZip(ScpStoreFeedbackQueryParamVO param, HttpServletRequest request, HttpServletResponse response);

    /**
     * 根据关键字段，返回对应的
     * @param Id ID
     * @return 对象
     */
    Optional<ScpStoreFeedbackRespVO> findIdOne(Long Id);
    /**
     * 创建
     *
     * @param  creatParam 对象
     */
    Long createOrUpdate(ScpStoreFeedbackSaveVO creatParam);

   /**
    * 批量审批
    * @param params
    */
    void approveBatch(ScpStoreFeedbackApproveVO params);

    @Transactional
   List<Long> createOrUpdateBatch(List<ScpStoreFeedbackSaveVO> params);
}


