package com.elitesland.scp.application.service.wqf;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.StringUtils;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.*;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.wqf.ScpWqfEntAccountApplyConvert;
import com.elitesland.scp.domain.convert.wqf.ScpWqfEntAccountApplyDConvert;
import com.elitesland.scp.domain.entity.wqf.ScpWqfEntAccountApplyDDO;
import com.elitesland.scp.domain.entity.wqf.ScpWqfEntAccountApplyDO;
import com.elitesland.scp.domain.service.whnet.ScpWhNetRelationDomainService;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.dto.wqf.ScpWqfEntAccountApplyDDTO;
import com.elitesland.scp.infr.dto.wqf.ScpWqfEntAccountApplyDTO;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepoProc;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountApplyDRepo;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountApplyDRepoProc;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountApplyRepo;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountApplyRepoProc;
import com.elitesland.scp.param.ScpWhNetRelationRpcDtoParam;
import com.elitesland.scp.pay.service.AccountBatchBindService;
import com.elitesland.scp.pay.vo.AccountBindParamVO;
import com.elitesland.scp.pay.vo.BankAccountParamVO;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 02月 28日 10:49
 * @version: 1.0
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ScpWqfEntAccountApplyServiceImpl implements ScpWqfEntAccountApplyService {

    private final OrgOuRpcService orgOuRpcService;

    private final ScpWqfEntAccountApplyRepoProc scpWqfEntAccountApplyRepoProc;

    private final OrgStoreRpcService orgStoreRpcService;

    private final ScpWqfEntAccountApplyDRepo scpWqfEntAccountApplyDRepo;

    private final ScpWqfEntAccountApplyRepo scpWqfEntAccountApplyRepo;

    private final RmiSysUserRpcService rmiSysUserRpcService;


    private final ScpWqfEntAccountApplyDRepoProc scpWqfEntAccountApplyDRepoProc;

    private final UdcProvider udcProvider;

    private final AccountBatchBindService accountBatchBindService;

    private final ScpWhNetRelationRepoProc scpWhNetRelationRepoProc;
    @Override
    @SysCodeProc
    public PagingVO<ScpWqfEntAccountApplyPageVO> page(ScpWqfEntAccountApplyPageParam paramVO) {
        PagingVO<ScpWqfEntAccountApplyPageVO> page = scpWqfEntAccountApplyRepoProc.page(paramVO);
        if(CollectionUtils.isNotEmpty(page.getRecords())){
            List<Long> ouIds = page.getRecords().stream().map(ScpWqfEntAccountApplyPageVO::getOuId).distinct().collect(Collectors.toList());
            List<OrgOuRpcSimpleDTO> simpleOuDto = orgOuRpcService.findSimpleOuDto(ouIds);
            Map<Long, OrgOuRpcSimpleDTO> ouMap = simpleOuDto.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getId, v -> v, (e1, e2) -> e1));
            page.getRecords().forEach(d -> {
                OrgOuRpcSimpleDTO ou = ouMap.get(d.getOuId());
                if(ou != null){
                    d.setOuName(ou.getOuName());
                }
            });
        }
        return page;
    }

    @Override
    public ScpWqfEntAccountApplyRespVO detail(Long id) {
        ScpWqfEntAccountApplyDO applyDO = scpWqfEntAccountApplyRepo.findById(id).orElseThrow(new BusinessException("数据不存在"));
        List<ScpWqfEntAccountApplyDDO> applyDDOS = scpWqfEntAccountApplyDRepo.findByMasId(id);
        ScpWqfEntAccountApplyRespVO respVo = ScpWqfEntAccountApplyConvert.INSTANCE.doToRespVo(applyDO);
        OrgOuRpcSimpleDTO simpleOuDto = orgOuRpcService.findSimpleOuDto(List.of(respVo.getOuId())).get(0);
        respVo.setOuCode(simpleOuDto.getOuCode());
        respVo.setOuName(simpleOuDto.getOuName());
        Map<String, String> accountTypeMap = udcProvider.getValueMapByUdcCode("yst-suplan", "WQF_ACCOUNT_TYPE");
        Map<String, String> wqfBankName = MapUtil.reverse(udcProvider.getValueMapByUdcCode("yst-suplan", "WQF_BANK_NAME"));
        if(CollectionUtils.isNotEmpty(applyDDOS)){
            List<ScpWqfEntAccountApplyDRespVO> respVOS = applyDDOS.stream().map(ScpWqfEntAccountApplyDConvert.INSTANCE::doToRespVo).collect(Collectors.toList());
            List<Long> storeIds = respVOS.stream().map(ScpWqfEntAccountApplyDRespVO::getStoreId).distinct().collect(Collectors.toList());
            OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
            baseRpcParam.setStoreIdList(storeIds);
            List<OrgStoreBaseRpcDTO> dtoList = orgStoreRpcService.findOrgStoreBaseByParam(baseRpcParam).computeData();
            Map<Long, OrgStoreBaseRpcDTO> storeMap = dtoList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getId, i -> i, (o, n) -> n));
            respVOS.forEach(d -> {
                OrgStoreBaseRpcDTO storeBaseRpcDTO = storeMap.get(d.getStoreId());
                if(storeBaseRpcDTO != null){
                    d.setStoreName(storeBaseRpcDTO.getStoreName());
                }
                d.setOpenBankCode(wqfBankName.get(d.getOpenBank()));
                d.setAccountTypeName(accountTypeMap.get(d.getAccountType()));
            });
            respVo.setDetails(respVOS);
        }
        return respVo;
    }

    @Override
    @Transactional
    public String save(ScpWqfEntAccountApplySaveVO createParam) {
        if(createParam.getApplyStatus() == null){
            createParam.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_DR.getValueCode());
        }else{
            if(!Objects.equals(createParam.getApplyStatus(),UdcEnum.WQF_APPLY_STATUS_DR.getValueCode()) &&
                    !Objects.equals(createParam.getApplyStatus(),UdcEnum.WQF_APPLY_STATUS_FAIL.getValueCode())){
                throw new BusinessException("该【草稿】或【处理失败】单据状态提交");
            }
        }
        ScpWqfEntAccountApplyDTO applyDTO = ScpWqfEntAccountApplyConvert.INSTANCE.saveVoToDto(createParam);
        applyDTO.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_DR.getValueCode());
        List<ScpWqfEntAccountApplyDSaveVO> details = createParam.getDetails();
        if(CollectionUtils.isNotEmpty(details) && details.size() >100){
            throw new BusinessException("单次提交不能超过100条");
        }else if(CollectionUtils.isNotEmpty(details)){
            long count = details.stream().map(ScpWqfEntAccountApplyDSaveVO::getStoreId).distinct().count();
            if(count != details.size()){
               throw new BusinessException(ApiCode.FAIL,"存在重复门店信息");
            }
            ScpWhNetRelationRpcDtoParam dtoParam = new ScpWhNetRelationRpcDtoParam();
            dtoParam.setOuCodes(List.of(createParam.getOuCode()));
            dtoParam.setType("0");
            List<ScpWhNetRelationRpcDTO> whNetRelationRpcDTOS = scpWhNetRelationRepoProc.findWhNetRelationRpcDtoByParam(dtoParam);
            if(CollectionUtils.isEmpty(whNetRelationRpcDTOS)){
                throw new BusinessException(ApiCode.FAIL,String.format("公司【%s】 未配置仓网关系门店信息",createParam.getOuName()));
            }else{
                List<String> stores = whNetRelationRpcDTOS.stream().map(ScpWhNetRelationRpcDTO::getDemandWhStCode).distinct().collect(Collectors.toList());
                List<String> storeList = details.stream().map(ScpWqfEntAccountApplyDSaveVO::getStoreCode).distinct().collect(Collectors.toList());
                storeList.stream().filter(d -> !stores.contains(d)).findAny().ifPresent(d ->{
                    throw new BusinessException(ApiCode.FAIL,String.format("公司【%s】未配置仓网关系门店【%s】信息",createParam.getOuName(),d));
                });
            }
        }
        if(createParam.getId() == null){
            applyDTO.setDocNo(rmiSysUserRpcService.sysNumberRuleGenerateCode(ScpConstant.WQF_APPLY,new ArrayList<>()));
            createParam.setDocNo(applyDTO.getDocNo());
            ScpWqfEntAccountApplyDO accountApplyDO = ScpWqfEntAccountApplyConvert.INSTANCE.dtoToDo(applyDTO);
            scpWqfEntAccountApplyRepo.save(accountApplyDO);
            createParam.setId(accountApplyDO.getId());
        }else{
            ScpWqfEntAccountApplyDO accountApplyDO = scpWqfEntAccountApplyRepo.findById(createParam.getId()).orElseThrow(new BusinessException("数据不存在"));
            if(!Objects.equals(accountApplyDO.getApplyStatus(),UdcEnum.WQF_APPLY_STATUS_DR.getValueCode())
                    && !Objects.equals(createParam.getApplyStatus(),UdcEnum.WQF_APPLY_STATUS_FAIL.getValueCode())){
                throw new BusinessException("该单据状态不允许修改");
            }
            ScpWqfEntAccountApplyConvert.INSTANCE.copyDtoToDo(applyDTO, accountApplyDO);
            scpWqfEntAccountApplyRepo.save(accountApplyDO);
            scpWqfEntAccountApplyDRepo.deleteByMasId(createParam.getId());

        }
        if(CollectionUtils.isNotEmpty(details)){
            List<Long> storeIds = details.stream().map(ScpWqfEntAccountApplyDSaveVO::getStoreId).distinct().collect(Collectors.toList());
            List<ScpWqfEntAccountApplyDDTO> wqfEntAccountApplyDDTOS = scpWqfEntAccountApplyDRepoProc.findByStoreIdAndOuId(storeIds, createParam.getOuId());
            if(CollectionUtils.isNotEmpty(wqfEntAccountApplyDDTOS)){
                for (ScpWqfEntAccountApplyDSaveVO detail : details) {
                    Map<Long, ScpWqfEntAccountApplyDDTO> ddtoMap = wqfEntAccountApplyDDTOS.stream().collect(Collectors.toMap(ScpWqfEntAccountApplyDDTO::getStoreId, i -> i, (o, n) -> n));
                    if(ddtoMap.containsKey(detail.getStoreId())){
                        throw new BusinessException(ApiCode.FAIL,String.format("公司【%s】已存在该门店【%s】的开户申请信息", createParam.getOuName(),detail.getStoreCode()));
                    }
                }
            }
            AtomicInteger linoNo = new AtomicInteger(0);
            List<ScpWqfEntAccountApplyDDTO> applyDDTOS = details.stream().map(d -> {
                ScpWqfEntAccountApplyDDTO applyDDTO = ScpWqfEntAccountApplyDConvert.INSTANCE.saveVoToDto(d);
                applyDDTO.setLineNo(linoNo.addAndGet(1));
                applyDDTO.setMasId(createParam.getId());
                return applyDDTO;
            }).collect(Collectors.toList());
            scpWqfEntAccountApplyDRepo.saveAll(applyDDTOS.stream()
                    .map(ScpWqfEntAccountApplyDConvert.INSTANCE::dtoToDo)
                    .collect(Collectors.toList()));
        }
        return createParam.getId().toString();
    }

    @Override
    @Transactional
    public String submit(ScpWqfEntAccountApplySaveVO saveVO) {
        this.save(saveVO);
        ScpWqfEntAccountApplyDO accountApplyDO = scpWqfEntAccountApplyRepo.findById(saveVO.getId()).orElseThrow(new BusinessException("数据不存在"));
        List<ScpWqfEntAccountApplyDDO> entAccountApplyDDOS = scpWqfEntAccountApplyDRepo.findByMasId(saveVO.getId());
        accountApplyDO.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_INIT.getValueCode());
        scpWqfEntAccountApplyRepo.save(accountApplyDO);
        //调用微企付封装接口
        wqfAccountBindHadler(accountApplyDO, entAccountApplyDDOS);
        return saveVO.getId().toString();
    }

    private void wqfAccountBindHadler(ScpWqfEntAccountApplyDO accountApplyDO, List<ScpWqfEntAccountApplyDDO> entAccountApplyDDOS) {
        List<OrgOuRpcSimpleDTO> simpleOuDto = orgOuRpcService.findSimpleOuDto(Collections.singletonList(accountApplyDO.getOuId()));
        Map<String, OrgOuRpcSimpleDTO> ouMap = simpleOuDto.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, v -> v, (e1, e2) -> e1));
        OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(accountApplyDO.getOuCode());
        if(ouRpcSimpleDTO == null){
            throw new BusinessException("未查询到公司信息");
        }
        try {
            AccountBindParamVO bindParamVO = new AccountBindParamVO();
            bindParamVO.setEntId(accountApplyDO.getEntId());
            bindParamVO.setOutRequestNo(accountApplyDO.getDocNo());
            List<BankAccountParamVO> bankAccountList = entAccountApplyDDOS.stream().map(d -> {
                BankAccountParamVO accountParamVO = new BankAccountParamVO();
                accountParamVO.setAccountType(d.getAccountType());
                accountParamVO.setBankAccountName(ouRpcSimpleDTO.getOuName());
                accountParamVO.setBankAccountNumber(d.getBankAccount());
                accountParamVO.setBankName(d.getOpenBank());
                accountParamVO.setBankBranchId(d.getBankBranchCode());
                accountParamVO.setBankBranchName(d.getBranchName());
                return accountParamVO;
            }).collect(Collectors.toList());
            bindParamVO.setBankAccountList(bankAccountList);
            log.info("调用微企付接口入参：{}", JSON.toJSONString(bindParamVO));
            accountBatchBindService.accountBind(bindParamVO);
            log.info("调用微企付接口成功：{}", JSON.toJSONString(bindParamVO));
            accountApplyDO.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_PROCESSING.getValueCode());
            accountApplyDO.setErrorMsg(null);
        } catch (Exception e){
            log.error("调用微企付接口失败",e);
            accountApplyDO.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_FAIL.getValueCode());
            accountApplyDO.setErrorMsg(e.getMessage().length() > 100 ? e.getMessage().substring(0, 100) : e.getMessage());
        }finally {
            scpWqfEntAccountApplyRepo.save(accountApplyDO);
        }
    }

    @Override
    public ApiResult<List<ScpWqfEntAccountApplyDRespVO>> importDetail(List<ScpWqfEntAccountApplyDImportVO> dates,ScpWqfEntAccountApplyImportParam param) {
        if(org.springframework.util.CollectionUtils.isEmpty(dates)){
            throw new BusinessException("导入数据为空");
        }
        if(dates.size() > 100){
            throw new BusinessException("导入数量不能超过100");
        }
        long count = dates.stream().map(ScpWqfEntAccountApplyDImportVO::getStoreCode).distinct().count();
        if(count != dates.size()){
            throw new BusinessException(ApiCode.FAIL,"存在重复门店信息");
        }
        List<String> storeCodes = dates.stream().map(ScpWqfEntAccountApplyDImportVO::getStoreCode).distinct().collect(Collectors.toList());
        List<OrgStoreDetailRpcDTO> storeDetailRpcDTOS = orgStoreRpcService.queryByStoreCodes(storeCodes);
        Map<String, OrgStoreDetailRpcDTO> storeMap = CollectionUtils.isEmpty(storeDetailRpcDTOS) ? new HashMap<>() : storeDetailRpcDTOS.stream()
                .collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, i -> i, (o, n) -> n));
        Map<String, String> wqfAccountType = MapUtil.reverse(udcProvider.getValueMapByUdcCode("yst-suplan", "WQF_ACCOUNT_TYPE"));
        Map<String, String> wqfBankName = MapUtil.reverse(udcProvider.getValueMapByUdcCode("yst-suplan", "WQF_BANK_NAME"));
        List<ScpWqfEntAccountApplyDRespVO> list = new ArrayList<>();
        for(int i=0 ; i<dates.size();i++){
            int row = i + 2;
            ScpWqfEntAccountApplyDImportVO importVO = dates.get(i);
            if(wqfBankName.get(importVO.getOpenBank()) == null){
                throw new BusinessException("第"+row+"行，开户银行【"+importVO.getOpenBank()+"】不存在");
            }
            if(StringUtils.isBlank(importVO.getStoreCode())){
                throw new BusinessException("第"+row+"行，门店编码不能为空");
            }
            if(storeMap.get(importVO.getStoreCode()) == null){
                throw new BusinessException("第"+row+"行，门店编码【"+importVO.getStoreCode()+"】不存在");
            }else{
                Long ouId = storeMap.get(importVO.getStoreCode()).getOuId();
//                if(!Objects.equals(param.getOuId(),ouId)){
//                    log.info("第"+row+"行，门店编码【"+importVO.getStoreCode()+"】不属于当前公司【"+param.getOuId()+"】");
//                    throw new BusinessException("第"+row+"行，门店编码【"+importVO.getStoreCode()+"】不属于当前公司");
//                }
            }
            if(wqfAccountType.get(importVO.getAccountTypeName()) == null){
                throw new BusinessException("第"+row+"行，账户类型【"+importVO.getAccountTypeName()+"】不存在");
            }
            ScpWqfEntAccountApplyDRespVO vo = ScpWqfEntAccountApplyDConvert.INSTANCE.importVoToRespVo(importVO);
            vo.setStoreId(storeMap.get(importVO.getStoreCode()).getId());
            vo.setStoreName(storeMap.get(importVO.getStoreCode()).getStoreName());
            vo.setAccountType(wqfAccountType.get(importVO.getAccountTypeName()));
            vo.setAccountTypeName(importVO.getAccountTypeName());
            list.add(vo);
        }
        return ApiResult.ok(list);
    }

    @Override
    @Transactional
    public List<Long> batchSubmit(List<Long> ids) {
        List<ScpWqfEntAccountApplyDO> applyDOList = scpWqfEntAccountApplyRepo.findAllById(ids);
        applyDOList.stream().filter(d -> ! UdcEnum.WQF_APPLY_STATUS_DR.getValueCode().equals(d.getApplyStatus()))
                .findAny().ifPresent(m ->{
                    throw new BusinessException(String.format("单据【%s】不允许提交,请选择【草稿】状态单据", m.getDocNo()));
                });
        Map<Long, ScpWqfEntAccountApplyDO> applyDOMap = applyDOList.stream().collect(Collectors.toMap(ScpWqfEntAccountApplyDO::getId, i -> i, (o, n) -> n));
        List<ScpWqfEntAccountApplyDDO> accountApplyDDOS = scpWqfEntAccountApplyDRepo.findAllByMasIdIn(ids);
        Map<Long, List<ScpWqfEntAccountApplyDDO>> detailMap = accountApplyDDOS.stream().collect(Collectors.groupingBy(ScpWqfEntAccountApplyDDO::getMasId));
        List<ScpWqfEntAccountApplyDO> sucessList = new ArrayList<>();
        for(Long id:ids){
            ScpWqfEntAccountApplyDO accountApplyDO = applyDOMap.get(id);
            List<ScpWqfEntAccountApplyDDO> accountApplyDDOList = detailMap.get(id);
            accountApplyDO.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_INIT.getValueCode());
            //调用微企付接口
            wqfAccountBindHadler(accountApplyDO,accountApplyDDOList);
            sucessList.add(accountApplyDO);
        }
        scpWqfEntAccountApplyRepo.saveAll(sucessList);
        return sucessList.stream().map(ScpWqfEntAccountApplyDO::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void delete(List<Long> ids) {
        List<ScpWqfEntAccountApplyDO> applyDOList = scpWqfEntAccountApplyRepo.findAllById(ids);
        applyDOList.stream().filter(d -> ! UdcEnum.WQF_APPLY_STATUS_DR.getValueCode().equals(d.getApplyStatus())
                        && ! UdcEnum.WQF_APPLY_STATUS_FAIL.getValueCode().equals(d.getApplyStatus()))
                .findAny().ifPresent(m ->{
                    throw new BusinessException(String.format("单据【%s】不允许删除,请选择【草稿】或【处理失败】状态单据", m.getDocNo()));
                });
        scpWqfEntAccountApplyRepo.deleteAllById(ids);
        scpWqfEntAccountApplyDRepo.deleteAllByMasIdIn(ids);
    }


}
