package com.elitesland.scp.domain.convert.stock;

import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockDownloadVO;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageVO;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockSaveVO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.stock.ScpSafetyTargetStockDO;
import com.elitesland.scp.infr.dto.stock.ScpSafetyTargetStockDTO;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2025-01-15
* @Version 1.0
**/
@Mapper
public interface ScpSafetyTargetStockConvert {

    ScpSafetyTargetStockConvert INSTANCE = Mappers.getMapper(ScpSafetyTargetStockConvert.class);

    ScpSafetyTargetStockDTO doToDto(ScpSafetyTargetStockDO scpSafetyTargetStockDO);

    ScpSafetyTargetStockDTO saveVoToDto(ScpSafetyTargetStockSaveVO safetyTargetStockSaveVO);

    ScpSafetyTargetStockDO dtoToDo(ScpSafetyTargetStockDTO dto);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void copySaveParamToDto(ScpSafetyTargetStockSaveVO saveVO, @MappingTarget ScpSafetyTargetStockDTO scpSafetyTargetStockDTO);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void copyPageVoToDownloadVo(ScpSafetyTargetStockPageVO pageVO, @MappingTarget ScpSafetyTargetStockDownloadVO safetyTargetStockDownloadVO);


}
