package com.elitesland.scp.domain.entity.msg;

import com.elitescloud.boot.core.support.customfield.common.JsonStringMapConverter;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * 运营消息内容.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/28
 */
@Entity
@Table(name = "scp_message_txt", indexes = {
        @Index(name = "idx_scp_msg_txt_msgid", columnList = "messageId"),
})
@Comment("运营消息内容")
@DynamicInsert
@Getter
@Setter
public class ScpMessageTxtDO extends BaseModel {
    private static final long serialVersionUID = -7627451721162411028L;

    @Comment(value = "消息ID")
    @Column(nullable = false)
    private Long messageId;

    @Comment(value = "消息内容")
    @Column()
    @Lob
    private String txt;

    @Comment(value = "附件标识，多个以逗号分隔")
    @Column()
    @Lob
    private String fileCodesStr;

    @Comment(value = "扩展属性")
    @Column()
    @Lob
    @Convert(converter = JsonStringMapConverter.class)
    private Map<String, Object> extAttr;
}
