package com.elitesland.scp.domain.entity.setting;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

@Entity
@Table(name = "scp_order_setting")
@org.hibernate.annotations.Table(appliesTo = "scp_order_setting", comment = "单据类型配置表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "单据类型配置表", description = "单据类型配置表")
@Where(clause = "delete_flag = 0")
public class ScpOrderSettingDO extends BaseModel implements Serializable {

    @ApiModelProperty("单据类型")
    @Comment("单据类型")
    @Column()
    private String docType;

    @ApiModelProperty("商品分类")
    @Comment("商品分类")
    @Column()
    private String itemCate;

    @ApiModelProperty("采购场景")
    @Comment("采购场景")
    @Column()
    private String purScene;

    @ApiModelProperty("采购场景名称")
    @Comment("采购场景名称")
    @Column()
    private String purSceneName;

    @ApiModelProperty("调拨订单单据类型")
    @Comment("调拨订单单据类型")
    @Column()
    private String trnType;

    @ApiModelProperty("第一优先级")
    @Comment("第一优先级")
    @Column()
    private String firstPriority;

    @ApiModelProperty("第二优先级")
    @Comment("第二优先级")
    @Column()
    private String secPriority;

    @ApiModelProperty("仓网供应关系是否计算运费")
    @Comment("仓网供应关系是否计算运费")
    @Column()
    private Boolean whnetFreightFlag;

    @ApiModelProperty("供应商份额分配是否计算运费")
    @Comment("供应商份额分配是否计算运费")
    @Column()
    private Boolean suppFreightFlag;

    @ApiModelProperty("是否启用,0:禁用,1:启用")
    @Comment("是否启用,0:禁用,1:启用")
    @Column()
    private Boolean status;

    @ApiModelProperty("要货类型")
    @Comment("要货类型")
    @Column()
    private String type;

    @ApiModelProperty("是否满额免运费")
    @Comment("是否满额免运费")
    @Column()
    private Boolean freeFreightFlag;

    @ApiModelProperty("免运费金额")
    @Comment("免运费金额")
    @Column()
    private BigDecimal freeFreightAmt;

    @ApiModelProperty("要求到货日期天数")
    @Comment("要求到货日期天数")
    @Column()
    private Long demandArriveDays;

}
