package com.elitesland.scp.domain.service.alloc;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingRegionPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingRegionRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingRegionSaveVO;
import com.elitesland.scp.domain.convert.alloc.ScpAllocSettingRegionConvert;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingRegionDO;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingRegionRepo;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingRegionRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpAllocSettingRegionDomainServiceImpl implements ScpAllocSettingRegionDomainService {

    private final ScpAllocSettingRegionRepo scpAllocSettingRegionRepo;
    private final ScpAllocSettingRegionRepoProc scpAllocSettingRegionRepoProc;

    @Override
    public List<ScpAllocSettingRegionRespVO> findByMasId(Long masId) {
        List<ScpAllocSettingRegionDO> settingItemDOS = scpAllocSettingRegionRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpAllocSettingRegionConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveAllocSettingRegion(List<ScpAllocSettingRegionSaveVO> saveVOS) {
        scpAllocSettingRegionRepo.saveAll(ScpAllocSettingRegionConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Long masId) {
        scpAllocSettingRegionRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        scpAllocSettingRegionRepo.deleteByIds(ids);
    }

    @Override
    public PagingVO<ScpAllocSettingRegionRespVO> page(ScpAllocSettingRegionPageParamVO paramVO) {
        long count = scpAllocSettingRegionRepoProc.countAllocSettingRegion(paramVO);
        if (count > 0) {
            List<ScpAllocSettingRegionRespVO> respVOList = scpAllocSettingRegionRepoProc.queryAllocSettingRegion(paramVO);
            return new PagingVO<>(count, respVOList);
        }
        return new PagingVO<>();
    }

    @Override
    public List<Long> findMasIdByRegionCode(String regionCode) {
        return scpAllocSettingRegionRepoProc.findMasIdByRegionCode(regionCode);
    }
}
