package com.elitesland.scp.domain.service.calendar;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.*;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.infr.dto.calendar.ScpStoreDemandCalendarDTO;
import com.elitesland.scp.infr.repo.calendar.ScpStoreDemandCalendarRepo;
import com.elitesland.scp.infr.repo.calendar.ScpStoreDemandCalendarRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2024/03/18
 */
@RequiredArgsConstructor
@Service
@Slf4j
public class ScpStoreDemandCalendarDomainServiceImpl implements ScpStoreDemandCalendarDomainService {

    private final ScpStoreDemandCalendarRepoProc storeDemandCalendarRepoProc;
    private final ScpStoreDemandCalendarRepo scpStoreDemandCalendarRepo;
    private final EntityManager entityManager;


    @Override
    public PagingVO<ScpStoreDemandCalendarPageVO> searchPage(ScpStoreDemandCalendarPageParamVO queryParam) {
        return storeDemandCalendarRepoProc.searchPage(queryParam);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(List<ScpStoreDemandCalendarDO> createList) {
        scpStoreDemandCalendarRepo.saveAll(createList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<Long> ids) {
        scpStoreDemandCalendarRepo.deleteAllById(ids);
    }

    @Override
    public List<ScpStoreDemandCalendarDO> findByConcatYearAndMonthKey(List<String> concatKey) {
        return scpStoreDemandCalendarRepo.findByConcatYearAndMonthKey(concatKey);
    }

    @Override
    public List<ScpStoreDemandCalendarDO> findByStoreDayCalendar(List<String> concatKey) {
        return scpStoreDemandCalendarRepo.findByStoreDayCalendar(concatKey);
    }

    @Override
    public List<ScpStoreDemandCalendarDTO> listCalendarDTOs(ScpStoreDemandCalendarParam scpStoreDemandCalendarParam) {
        return storeDemandCalendarRepoProc.findDemandCalendarByParam(scpStoreDemandCalendarParam);
    }

    @Override
    @SysCodeProc
    public List<ScpStoreDemandCalendarDTO> findStoreCalendarByParam(ScpStoreDemandCalendarParamVO param) {
        return storeDemandCalendarRepoProc.findStoreCalendarByParam(param);
    }

    @Override
    public List<ScpCalendarStoreRespVO> listStoreByQueryParam(ScpCalendarStoreQueryParamVO param) {
        return storeDemandCalendarRepoProc.listStoreByQueryParam(param);
    }

    @Override
    public void batchInsert(List<ScpStoreDemandCalendarDO> createList, int batchSize) {
        int index = 0;
        for (ScpStoreDemandCalendarDO data : createList) {
            entityManager.persist(data);
            if (batchSize > 1) {
                // 开启批量
                index++;
                if (index % batchSize == 0) {
                    entityManager.flush();
                    entityManager.clear();
                }
            }
        }
        if (!createList.isEmpty()) {
            entityManager.flush();
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByStoreAndYear(List<String> storeCodes, String year) {
        storeDemandCalendarRepoProc.deleteByStoreAndYear(storeCodes, year);
    }
}