package com.elitesland.scp.domain.service.setting;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.setting.ScpOrderSettingSaveVO;
import com.elitesland.scp.domain.convert.setting.ScpOrderSettingConvert;
import com.elitesland.scp.domain.entity.setting.ScpOrderSettingDO;
import com.elitesland.scp.infr.dto.setting.ScpOrderSettingDTO;
import com.elitesland.scp.infr.repo.setting.ScpOrderSettingRepo;
import com.elitesland.scp.infr.repo.setting.ScpOrderSettingRepoProc;
import com.elitesland.scp.rmi.RmiSysUDCService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpOrderSettingDomainServiceImpl implements ScpOrderSettingDomainService {

    private final RedisTemplate redisTemplate;
    private final RmiSysUDCService rmiSysUDCService;
    private final ScpOrderSettingRepo scpOrderSettingRepo;
    private final ScpOrderSettingRepoProc scpOrderSettingRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ScpOrderSettingPageRespVO> queryOrderSettingList(ScpOrderSettingPageParamVO paramVO) {
        long count = scpOrderSettingRepoProc.countOrderSetting(paramVO);
        if (count > 0) {
            Map<String, String> itemType2 = rmiSysUDCService.getCodeMap("yst-supp", "ITEM_TYPE2");
            var demandSet = scpOrderSettingRepoProc.queryOrderSetting(paramVO);
            demandSet.stream().forEach(scpOrderSettingRespVO -> {
                if (StrUtil.isNotBlank(scpOrderSettingRespVO.getItemCate())) {
                    List<String> itemCateName = StrUtil.split(scpOrderSettingRespVO.getItemCate(), ',').stream().map(row -> itemType2.get(row)).collect(Collectors.toList());
                    scpOrderSettingRespVO.setItemCateNames(itemCateName);
                }
            });
            return new PagingVO<>(count, demandSet);
        }
        return new PagingVO<>();
    }

    @Override
    @SysCodeProc
    public Optional<ScpOrderSettingDTO> findOrderSettingById(Long id) {
        return scpOrderSettingRepo.findById(id).map(row -> {
            ScpOrderSettingDTO scpOrderSettingDTO = ScpOrderSettingConvert.INSTANCE.doToDto(row);
            scpOrderSettingDTO.setItemCates(StrUtil.split(row.getItemCate(), ','));
            return scpOrderSettingDTO;
        });
    }

    @Override
    public Long saveOrderSetting(ScpOrderSettingSaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpOrderSettingDO intentDO = ScpOrderSettingConvert.INSTANCE.saveVoToDO(saveVO);
            if (CollUtil.isNotEmpty(saveVO.getItemCates())) {
                intentDO.setItemCate(String.join(",", saveVO.getItemCates()));
            }
            Long masId = scpOrderSettingRepo.save(intentDO).getId();
            redisTemplate.opsForValue().set(intentDO.getDocType() + intentDO.getDocType(), JSONUtil.toJsonStr(intentDO));
            return masId;
        } else {
            Optional<ScpOrderSettingDO> option = scpOrderSettingRepo.findById(saveVO.getId());
            if (option.isEmpty()) {
                throw new BusinessException("单据类型配置ID：" + saveVO.getId() + "不存在");
            }
            ScpOrderSettingDO scpOrderSettingDO = option.get();
            ScpOrderSettingConvert.INSTANCE.copySaveParamToDo(saveVO, scpOrderSettingDO);
            if (CollUtil.isNotEmpty(saveVO.getItemCates())) {
                scpOrderSettingDO.setItemCate(String.join(",", saveVO.getItemCates()));
            } else {
                scpOrderSettingDO.setItemCate(null);
            }
            Long masId = scpOrderSettingRepo.save(scpOrderSettingDO).getId();
            redisTemplate.opsForValue().set(scpOrderSettingDO.getDocType() + scpOrderSettingDO.getType(), JSONUtil.toJsonStr(scpOrderSettingDO));
            return masId;
        }
    }

    @Override
    public void enableOrderSetting(List<Long> ids, Boolean enable) {
        scpOrderSettingRepoProc.enableDemandSet(ids, enable);
        List<ScpOrderSettingDO> settingDOS = scpOrderSettingRepo.findByIdIn(ids);
        settingDOS.forEach(scpOrderSettingDO -> {
            scpOrderSettingDO.setStatus(enable);
            redisTemplate.opsForValue().set(scpOrderSettingDO.getDocType()+scpOrderSettingDO.getType(), JSONUtil.toJsonStr(scpOrderSettingDO));
        });
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        List<ScpOrderSettingDO> settingDOS = scpOrderSettingRepo.findByIdIn(ids);
        scpOrderSettingRepoProc.deleteByIds(ids);
        settingDOS.forEach(scpOrderSettingDO -> redisTemplate.delete(scpOrderSettingDO.getDocType()));
    }

    @Override
    public List<ScpOrderSettingRespVO> findByParam(ScpOrderSettingParamVO paramVO) {
        return scpOrderSettingRepoProc.findByParam(paramVO);
    }

    @Override
    public List<String> findItemCatesByDocType(String docType, String type) {
        Object cacheData = redisTemplate.opsForValue().get(docType + type);
        if (cacheData == null) {
            ScpOrderSettingParamVO paramVO = new ScpOrderSettingParamVO();
            paramVO.setDocType(docType);
            paramVO.setType(type);
            List<ScpOrderSettingRespVO> settings = scpOrderSettingRepoProc.findByParam(paramVO);
            if (settings.isEmpty()) {
                return new ArrayList<>();
            }
            cacheData = JSONUtil.toJsonStr(settings.get(0));
            redisTemplate.opsForValue().set(docType + type, cacheData);
        }
        ScpOrderSettingDO scpOrderSettingDO = JSON.parseObject((String) cacheData, ScpOrderSettingDO.class);
        return StrUtil.split(scpOrderSettingDO.getItemCate(), ",");
    }

    @Override
    public ScpOrderSettingRespVO findCacheByDocType(String docType, String type) {
        Object cacheData = redisTemplate.opsForValue().get(docType + type);
        if (cacheData == null) {
            ScpOrderSettingParamVO paramVO = new ScpOrderSettingParamVO();
            paramVO.setDocType(docType);
            paramVO.setType(type);
            paramVO.setStatus(Boolean.TRUE);
            List<ScpOrderSettingRespVO> settings = scpOrderSettingRepoProc.findByParam(paramVO);
            if (settings.isEmpty()) {
                throw new BusinessException("请先配置或启用单据类型" + docType);
            }
            cacheData = JSONUtil.toJsonStr(settings.get(0));
            redisTemplate.opsForValue().set(docType + type, cacheData);
        }
        return ScpOrderSettingConvert.INSTANCE.doToRespVO(JSON.parseObject((String) cacheData, ScpOrderSettingDO.class));
    }

    @Override
    @SysCodeProc
    public List<ScpOrderSettingRespVO> findEnabledSetting() {
        return scpOrderSettingRepoProc.findEnabledSetting();
    }
}
