package com.elitesland.scp.infr.repo.freight;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightExportRespVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightPageParamVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightRespVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightSaveParamVO;
import com.elitesland.scp.application.facade.vo.resp.freight.ScpStoreOrderFreightPageRespVO;
import com.elitesland.scp.domain.entity.freight.QScpStoreOrderFreightDO;
import com.elitesland.scp.domain.entity.freight.ScpStoreOrderFreightDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Component
@RequiredArgsConstructor
public class ScpStoreOrderFreightRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpStoreOrderFreightDO jpaQDo = QScpStoreOrderFreightDO.scpStoreOrderFreightDO;

    public PagingVO<ScpStoreOrderFreightPageRespVO> findByParam(ScpStoreOrderFreightPageParamVO paramVO) {
        JPAQuery<ScpStoreOrderFreightPageRespVO>
                jpaQuery = jpaQueryFactory.select(Projections.bean(ScpStoreOrderFreightPageRespVO.class,
                jpaQDo.id,
                jpaQDo.orderType,
                jpaQDo.freightMethod,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.demandType,
                jpaQDo.storeCode,
                jpaQDo.storeName,
                jpaQDo.itemCode,
                jpaQDo.itemName,
                jpaQDo.itemCategoryCode,
                jpaQDo.freightRate,
                jpaQDo.amountPerQuantity,
                jpaQDo.status,
                jpaQDo.createTime
            ))
            .from(jpaQDo);
        jpaQuery.orderBy(jpaQDo.createTime.desc());
        this.where(jpaQuery, paramVO);
        paramVO.setPaging(jpaQuery);
        log.info(JSON.toJSONString(jpaQuery.fetch()));
       // paramVO.fillOrders(jpaQuery, jpaQDo);

        return PagingVO.<ScpStoreOrderFreightPageRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }
    public List<ScpStoreOrderFreightPageRespVO> listByParam(ScpStoreOrderFreightPageParamVO paramVO) {
        JPAQuery<ScpStoreOrderFreightPageRespVO>
                jpaQuery = jpaQueryFactory.select(Projections.bean(ScpStoreOrderFreightPageRespVO.class,
                        jpaQDo.id,
                        jpaQDo.orderType,
                        jpaQDo.freightMethod,
                        jpaQDo.whCode,
                        jpaQDo.whName,
                        jpaQDo.demandType,
                        jpaQDo.storeCode,
                        jpaQDo.storeName,
                        jpaQDo.itemCode,
                        jpaQDo.itemName,
                        jpaQDo.itemCategoryCode,
                        jpaQDo.freightRate,
                        jpaQDo.amountPerQuantity,
                        jpaQDo.status,
                        jpaQDo.createTime
                ))
                .from(jpaQDo);
        jpaQuery.orderBy(jpaQDo.createTime.desc());
        this.where(jpaQuery, paramVO);
        return jpaQuery.fetch();
    }



    // 这是一个全量导出
    public PagingVO<ScpStoreOrderFreightPageRespVO> findAll(ScpStoreOrderFreightPageParamVO paramVO) {
        JPAQuery<ScpStoreOrderFreightPageRespVO>
                jpaQuery = jpaQueryFactory.select(Projections.bean(ScpStoreOrderFreightPageRespVO.class,
                // jpaQDo.id,
                jpaQDo.orderType,
                jpaQDo.freightMethod,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.demandType,
                jpaQDo.storeCode,
                jpaQDo.storeName,
                jpaQDo.itemCode,
                jpaQDo.itemName,
                // jpaQDo.itemCategoryCode,
                jpaQDo.freightRate,
                jpaQDo.amountPerQuantity,
                jpaQDo.status,
                jpaQDo.createTime
                )).from(jpaQDo).orderBy(jpaQDo.createTime.desc());
        paramVO.setPaging(jpaQuery);
        return PagingVO.<ScpStoreOrderFreightPageRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    // 判重用
    public List<ScpStoreOrderFreightDO> findByParam2(ScpStoreOrderFreightSaveParamVO paramVO) {
        var
                jpaQuery = jpaQueryFactory.select(Projections.fields(ScpStoreOrderFreightDO.class,
                jpaQDo.id.as("id"),
                jpaQDo.orderType,
                jpaQDo.freightMethod,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.demandType,
                jpaQDo.storeCode,
                jpaQDo.storeName,
                jpaQDo.itemCode,
                jpaQDo.itemName,
                jpaQDo.itemCategoryCode,
                jpaQDo.freightRate,
                jpaQDo.amountPerQuantity,
                jpaQDo.status
            ))
            .from(jpaQDo);
        jpaQuery.where(
                jpaQDo.orderType.eq(paramVO.getOrderType())
                    .and(jpaQDo.orderType.eq(paramVO.getOrderType()))
                    .and(jpaQDo.storeCode.eq(paramVO.getStoreCode()))
                    .and(jpaQDo.status.eq(1))
        );
        // 如果商品为空也要判断
        if (paramVO.getItemCode() == null) {
            jpaQuery.where(jpaQDo.itemCode.isNull());
        } else {
            jpaQuery.where(jpaQDo.itemCode.eq(paramVO.getItemCode()));
        }
        // 如果供货仓库为空也要判断
        if (paramVO.getWhCode() == null) {
            jpaQuery.where(jpaQDo.whCode.isNull());
        } else {
            jpaQuery.where(jpaQDo.whCode.eq(paramVO.getWhCode()));
        }
        return jpaQuery.fetch();
    }

    private void where(JPAQuery<ScpStoreOrderFreightPageRespVO> jpaQuery, ScpStoreOrderFreightPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (paramVO.getStoreCodeList() != null && !paramVO.getStoreCodeList().isEmpty()) {
            if (!paramVO.getStoreCodeList().get(0).equals("all")) {
                predicates.add(jpaQDo.storeCode.in(paramVO.getStoreCodeList()));
            }
        }
        if (!CollectionUtils.isEmpty(paramVO.getStoreCodes())) {
            predicates.add(jpaQDo.storeCode.in(paramVO.getStoreCodes()));
        }
        if (paramVO.getStoreNameList() != null && !paramVO.getStoreNameList().isEmpty()) {
            if (!paramVO.getStoreNameList().get(0).equals("全部")) {
                predicates.add(jpaQDo.storeName.in(paramVO.getStoreNameList()));
            }
        }
        if (StrUtil.isNotBlank(paramVO.getOrderType())) {
            predicates.add(jpaQDo.orderType.eq(paramVO.getOrderType()));
        }
        if (StrUtil.isNotBlank(paramVO.getFreightMethod())) {
            predicates.add(jpaQDo.freightMethod.eq(paramVO.getFreightMethod()));
        }
        if (paramVO.getWhCodeList() != null && !paramVO.getWhCodeList().isEmpty()) {
            predicates.add(jpaQDo.whCode.in(paramVO.getWhCodeList()));
        }
        if (paramVO.getWhNameList() != null && !paramVO.getWhNameList().isEmpty()) {
            predicates.add(jpaQDo.whName.in(paramVO.getWhNameList()));
        }
        if (paramVO.getItemCodeList() != null && !paramVO.getItemCodeList().isEmpty()){
            predicates.add(jpaQDo.itemCode.in(paramVO.getItemCodeList()));
        }
        if (paramVO.getItemNameList() != null && !paramVO.getItemNameList().isEmpty()){
            predicates.add(jpaQDo.itemName.in(paramVO.getItemNameList()));
        }
        if (paramVO.getItemCategoryCode() != null && !paramVO.getItemCategoryCode().isEmpty()){
            predicates.add(jpaQDo.itemCategoryCode.like(paramVO.getItemCategoryCode() + "%"));
        }
        if (paramVO.getStatus() != null && (paramVO.getStatus() == 1 || paramVO.getStatus() == 0)) {
            predicates.add(jpaQDo.status.eq(paramVO.getStatus()));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
    }
}
