package com.elitesland.scp.lakalapay.utils;



import org.apache.commons.codec.binary.Base64;



import javax.crypto.*;

import javax.crypto.spec.SecretKeySpec;

import java.io.ByteArrayOutputStream;

import java.io.IOException;

import java.io.UnsupportedEncodingException;

import java.net.URLEncoder;

import java.security.*;

import java.security.spec.InvalidKeySpecException;

import java.security.spec.PKCS8EncodedKeySpec;

import java.security.spec.X509EncodedKeySpec;

import java.util.Map;

import java.util.Set;

import java.util.TreeSet;



public class RSA {

    public static final String SIGN_ALGORITHMS = "SHA1WithRSA";



    /**

     * 密钥算法RSA

     */

    public static final String KEY_ALGORITHM = "RSA";



    /**

     * 加密算法RSA

     */

    public static final String CIPHER_ALGORITHM = "RSA/ECB/PKCS1PADDING";



    /**

     * RSA最大加密明文大小

     */

    private static final int MAX_ENCRYPT_BLOCK = 117;



    /**

     * RSA最大解密密文大小

     */

    private static final int MAX_DECRYPT_BLOCK = 128;



    /**

     * RSA签名

     *

     * @param content       待签名数据

     * @param privateKey    商户私钥

     * @param input_charset 编码格式

     * @return 签名值

     */

    public static String sign(String content, String privateKey, String input_charset) {

        try {

            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decodeBase64(privateKey));

            KeyFactory keyf = KeyFactory.getInstance("RSA");

            PrivateKey priKey = keyf.generatePrivate(priPKCS8);



            java.security.Signature signature = java.security.Signature

                    .getInstance(SIGN_ALGORITHMS);



            signature.initSign(priKey);

            signature.update(content.getBytes(input_charset));



            byte[] signed = signature.sign();



            return Base64.encodeBase64String(signed);

        } catch (Exception e) {

            System.err.println("签名异常" + e.getMessage());

        }



        return null;

    }



    /**

     * RSA验签名检查

     *

     * @param content        待签名数据

     * @param sign           签名值

     * @param ali_public_key 支付宝公钥

     * @param input_charset  编码格式

     * @return 布尔值

     */

    public static boolean verify(String content, String sign, String ali_public_key, String input_charset) {

        try {

            KeyFactory keyFactory = KeyFactory.getInstance("RSA");

            byte[] encodedKey = Base64.decodeBase64(ali_public_key);

            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));





            java.security.Signature signature = java.security.Signature

                    .getInstance(SIGN_ALGORITHMS);



            signature.initVerify(pubKey);

            signature.update(content.getBytes(input_charset));



            boolean bverify = signature.verify(Base64.decodeBase64(sign));

            return bverify;



        } catch (Exception e) {

            System.err.println("验证异常" + e.getMessage());

        }



        return false;

    }



    /**

     * 公钥加密

     *

     * @param srcData   源数据

     * @param publicKey 公钥(BASE64编码)

     * @throws NoSuchAlgorithmException

     * @throws InvalidKeySpecException

     * @throws NoSuchPaddingException

     * @throws InvalidKeyException

     * @throws BadPaddingException

     * @throws IllegalBlockSizeException

     * @throws UnsupportedEncodingException

     */

    public static String encryptByPublicKey(String srcData, String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {

        ByteArrayOutputStream out = null;

        try {

            byte[] keyBytes = Base64.decodeBase64(publicKey.getBytes());

            byte[] data = srcData.getBytes("utf-8");

            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);

            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);

            Key publicK = keyFactory.generatePublic(x509KeySpec);

            // 对数据加密

            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);

            cipher.init(Cipher.ENCRYPT_MODE, publicK);

            int inputLen = data.length;

            out = new ByteArrayOutputStream();

            int offSet = 0;

            byte[] cache;

            int i = 0;

            // 对数据分段加密

            while (inputLen - offSet > 0) {

                if (inputLen - offSet > MAX_ENCRYPT_BLOCK) {

                    cache = cipher.doFinal(data, offSet, MAX_ENCRYPT_BLOCK);

                } else {

                    cache = cipher.doFinal(data, offSet, inputLen - offSet);

                }

                out.write(cache, 0, cache.length);

                i++;

                offSet = i * MAX_ENCRYPT_BLOCK;

            }

            byte[] encryptedData = out.toByteArray();

            return Base64.encodeBase64String(encryptedData);

        } finally {

            try {

                if (out != null) {

                    out.close();

                }

            } catch (IOException e) {

                e.printStackTrace();

            }

        }

    }

    public static String getSignHmacSHA256(Map<String,Object> params, String secret) {

        String sortStr = null;

        try {

            sortStr = getSortedParam(params);

        } catch (UnsupportedEncodingException e) {

            throw new RuntimeException("参数排序失败", e);

        }

        return signHS256(secret, sortStr);

    }

    public static String getSortedParam(Map<String, Object> params) throws UnsupportedEncodingException {

        Set<String> sortedParams = new TreeSet<>(params.keySet());

        StringBuilder sortedParamStr = new StringBuilder();

        for (String key : sortedParams) {

            String value = String.valueOf(params.get(key));

            // 排除sign

            if (null != value && !"".equals(value) && !"sign".equalsIgnoreCase(key)) {

                sortedParamStr.append(key + "=" + URLEncoder.encode(value, "UTF-8") + "&");

            }

        }

        return sortedParamStr.substring(0, sortedParamStr.length() - 1);

    }



    public static String signHS256(String appSecret, String baseUrl) {

        try {

            Mac hs256 = Mac.getInstance("HmacSHA256");

            SecretKeySpec secretKey = new SecretKeySpec(appSecret.getBytes("UTF-8"), "HmacSHA256");

            hs256.init(secretKey);

            byte[] bytes = hs256.doFinal(baseUrl.getBytes("UTF-8"));



            return toHex(bytes);

        } catch (NoSuchAlgorithmException e) {

            throw new RuntimeException("不支持HmacSHA256算法", e);

        } catch (UnsupportedEncodingException e) {

            throw new RuntimeException("不支持utf8编码", e);

        } catch (Exception e) {

            throw new RuntimeException("hs256签名失败", e);

        }

    }

    public static String toHex(byte[] bytes) {

        StringBuffer hexstr = new StringBuffer();

        for (int i = 0; i < bytes.length; i++) {

            String b = Integer.toHexString(bytes[i] & 0xFF);

            if (b.length() < 2) {

                hexstr.append(0);

            }

            hexstr.append(b);

        }



        return hexstr.toString();

    }

    /**

     * 私钥加密

     *

     * @param srcData    源数据

     * @param privateKey 私钥(BASE64编码)

     * @throws NoSuchAlgorithmException

     * @throws InvalidKeySpecException

     * @throws NoSuchPaddingException

     * @throws InvalidKeyException

     * @throws BadPaddingException

     * @throws IllegalBlockSizeException

     * @throws UnsupportedEncodingException

     */

    public static String encryptByPrivateKey(String srcData, String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {

        ByteArrayOutputStream out = null;

        try {

            byte[] keyBytes = Base64.decodeBase64(privateKey.getBytes());

            byte[] data = srcData.getBytes("utf-8");

            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);

            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);

            Key privateK = keyFactory.generatePrivate(pkcs8KeySpec);

            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);

            cipher.init(Cipher.ENCRYPT_MODE, privateK);

            int inputLen = data.length;

            out = new ByteArrayOutputStream();

            int offSet = 0;

            byte[] cache;

            int i = 0;

            // 对数据分段加密

            while (inputLen - offSet > 0) {

                if (inputLen - offSet > MAX_ENCRYPT_BLOCK) {

                    cache = cipher.doFinal(data, offSet, MAX_ENCRYPT_BLOCK);

                } else {

                    cache = cipher.doFinal(data, offSet, inputLen - offSet);

                }

                out.write(cache, 0, cache.length);

                i++;

                offSet = i * MAX_ENCRYPT_BLOCK;

            }

            byte[] encryptedData = out.toByteArray();

            return Base64.encodeBase64String(encryptedData);

        } finally {

            try {

                if (out != null) {

                    out.close();

                }

            } catch (IOException e) {

                e.printStackTrace();

            }

        }

    }



    /**

     * 公钥解密

     *

     * @param srcData   已加密数据

     * @param publicKey 公钥(BASE64编码)

     * @throws NoSuchAlgorithmException

     * @throws InvalidKeySpecException

     * @throws NoSuchPaddingException

     * @throws InvalidKeyException

     * @throws BadPaddingException

     * @throws IllegalBlockSizeException

     * @throws UnsupportedEncodingException

     */

    public static String decryptByPublicKey(String srcData, String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {

        ByteArrayOutputStream out = null;

        try {

            byte[] keyBytes = Base64.decodeBase64(publicKey.getBytes());

            byte[] encryptedData = Base64.decodeBase64(srcData.getBytes());

            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);

            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);

            Key publicK = keyFactory.generatePublic(x509KeySpec);

            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);

            cipher.init(Cipher.DECRYPT_MODE, publicK);

            int inputLen = encryptedData.length;

            out = new ByteArrayOutputStream();

            int offSet = 0;

            byte[] cache;

            int i = 0;

            // 对数据分段解密

            while (inputLen - offSet > 0) {

                if (inputLen - offSet > MAX_DECRYPT_BLOCK) {

                    cache = cipher.doFinal(encryptedData, offSet, MAX_DECRYPT_BLOCK);

                } else {

                    cache = cipher.doFinal(encryptedData, offSet, inputLen - offSet);

                }

                out.write(cache, 0, cache.length);

                i++;

                offSet = i * MAX_DECRYPT_BLOCK;

            }

            byte[] decryptedData = out.toByteArray();

            return new String(decryptedData, "utf-8");

        } finally {

            try {

                if (out != null) {

                    out.close();

                }

            } catch (IOException e) {

                e.printStackTrace();

            }

        }

    }





    /**

     * 私钥解密

     *

     * @param srcData    已加密数据

     * @param privateKey 私钥(BASE64编码)

     * @throws InvalidKeySpecException

     * @throws NoSuchAlgorithmException

     * @throws NoSuchPaddingException

     * @throws InvalidKeyException

     * @throws BadPaddingException

     * @throws IllegalBlockSizeException

     * @throws UnsupportedEncodingException

     */

    public static String decryptByPrivateKey(String srcData, String privateKey) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {

        ByteArrayOutputStream out = null;

        try {

            byte[] keyBytes = Base64.decodeBase64(privateKey.getBytes());

            byte[] encryptedData = Base64.decodeBase64(srcData);

            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);

            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);

            Key privateK = keyFactory.generatePrivate(pkcs8KeySpec);

            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);

            cipher.init(Cipher.DECRYPT_MODE, privateK);

            int inputLen = encryptedData.length;

            out = new ByteArrayOutputStream();

            int offSet = 0;

            byte[] cache;

            int i = 0;

            // 对数据分段解密

            while (inputLen - offSet > 0) {

                if (inputLen - offSet > MAX_DECRYPT_BLOCK) {

                    cache = cipher.doFinal(encryptedData, offSet, MAX_DECRYPT_BLOCK);

                } else {

                    cache = cipher.doFinal(encryptedData, offSet, inputLen - offSet);

                }

                out.write(cache, 0, cache.length);

                i++;

                offSet = i * MAX_DECRYPT_BLOCK;

            }

            byte[] decryptedData = out.toByteArray();

            return new String(decryptedData, "utf-8");

        } finally {

            try {

                if (out != null) {

                    out.close();

                }

            } catch (IOException e) {

                e.printStackTrace();

            }

        }

    }

}