package com.elitesland.scp.pay.controller;

import cn.hutool.json.JSONUtil;
import com.elitesland.scp.pay.service.RefundsService;
import com.elitesland.scp.pay.vo.RefundParamVO;
import com.tenpay.business.entpay.mse.sdk.api.Refund;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequiredArgsConstructor
@RequestMapping("/refund")
public class RefundsController {

    private final RefundsService refundsService;

    // 退款申请
    @ApiOperation("退款申请 - 小程序调用")
    @PostMapping("/create/{paymentId}")
    public Refund create(@PathVariable("paymentId") String paymentId) throws EntpayException {
        log.info("退款申请请求参数-小程序调用：{}", paymentId);
        return refundsService.refundOrder(paymentId);
    }

    // 退款查询（内单号）
    @ApiOperation("退款查询（内单号）")
    @GetMapping("/retrieve/{refundId}")
    public Refund retrieve(@PathVariable("refundId") String refundId) throws EntpayException {
        log.info("退款查询(内单号)请求参数：{}", refundId);
        return Refund.retrieve(refundId);
    }

    // 退款查询（外单号）
    @ApiOperation("退款查询（外单号）")
    @GetMapping("/retrieve/out-refund-id/{outRefundId}")
    public Refund retrieveByOutRefundId(@PathVariable("outRefundId") String outRefundId) throws EntpayException {
        log.info("退款查询(外单号)请求参数：{}", outRefundId);
        return Refund.retrieveByOutRefundId(outRefundId);
    }


    @ApiOperation("退款申请-手动")
    @PostMapping("/create/manu")
    public Refund create(@RequestBody RefundParamVO refundParamVO) throws EntpayException {
        log.info("退款申请请求参数-手动：{}", JSONUtil.toJsonStr(refundParamVO));
        return refundsService.refundOrderManu(refundParamVO);
    }

}
