package com.elitesland.scp.pay.service;

import cn.hutool.json.JSONUtil;
import com.elitesland.scp.pay.vo.RefundParamVO;
import com.elitesland.scp.utils.RandomUtil;
import com.tenpay.business.entpay.mse.sdk.api.Refund;
import com.tenpay.business.entpay.mse.sdk.common.NotifyHandler;
import com.tenpay.business.entpay.mse.sdk.config.EntpayConfig;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import com.tenpay.business.entpay.mse.sdk.model.RefundNotifyModel;
import com.tenpay.business.entpay.mse.sdk.model.RefundParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

@Slf4j
@Service
@RequiredArgsConstructor
public class RefundsServiceImpl implements RefundsService {

    private final NotifyVerifyService notifyVerifyService;

    @Override
    public Refund refundOrder(String paymentId) throws EntpayException {
        // 封装退款申请入参
        RefundParam refundParam = constructRefundParam(paymentId);
        // 调用退款申请接口
        log.info("退款申请接口入参:{}", JSONUtil.toJsonStr(refundParam));
        Refund refund = Refund.create(refundParam);
        log.info("退款申请结果:{}", JSONUtil.toJsonStr(refund));
        return refund;
    }

    @Override
    public String refundNotify(String body, String authorization) throws EntpayException, JSONException {
        // 验签并获取model
        RefundNotifyModel model = NotifyHandler.handlerWebhook(body, authorization, RefundNotifyModel.class,
                EntpayConfig.getRealTbepPublicKey(null));
        log.info("退款回调通知数据：{}", JSONUtil.toJsonStr(model));
        notifyVerifyService.processRefundNotify(model);
        // 封装响应参数
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("retcode", 0);
        jsonObject.put("retmsg", "SUCCESS");
        return jsonObject.toString();
    }

    @Override
    public Refund refundOrderManu(RefundParamVO refundParamVO) throws EntpayException {
        // 封装退款申请入参
        RefundParam refundParam = RefundParam.builder()
                .entId(refundParamVO.getEntId())
                .outRefundId(refundParamVO.getOutRefundId())
                .paymentId(refundParamVO.getPaymentId())
                .totalAmount(refundParamVO.getTotalAmount().multiply(new BigDecimal("100")).longValue())
                .refundAmount(refundParamVO.getRefundAmount().multiply(new BigDecimal("100")).longValue())
                .refundReason(refundParamVO.getRefundReason())
                .serverNotifyUrl("https://datacenter.zhengxinshipin.com/yst/scp/notify/refund")
                .build();
        // 调用退款申请接口
        log.info("退款申请接口入参:{}", JSONUtil.toJsonStr(refundParam));
        Refund refund = Refund.create(refundParam);
        log.info("退款申请结果:{}", JSONUtil.toJsonStr(refund));
        return refund;
    }

    private RefundParam constructRefundParam(String paymentId) {
        return RefundParam.builder()
                .entId("100403095693")
                .outRefundId(RandomUtil.getRandom(20))
                .paymentId(paymentId)
                .totalAmount(100L)
                .refundAmount(10L)
                .refundReason("退款原因")
                .serverNotifyUrl("https://test-api-business.tenpay.com/donghao/notify/notify/profit_allocation")
                .build();
    }

}
