package com.elitesland.scp.provider.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageParam;
import com.elitesland.scp.application.service.boh.StoreReceiveService;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderDConvert;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.dto.order.*;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.param.ScpOrderUnRecvParamVO;
import com.elitesland.scp.service.order.ScpDemandOrderDRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
@RestController
@RequiredArgsConstructor
@RequestMapping(ScpApplication.URI_PREFIX + ScpDemandOrderDRpcService.PATH)
public class ScpDemandOrderDRpcServiceImpl implements ScpDemandOrderDRpcService {

    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final StoreReceiveService storeReceiveService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> updateDemandOrderDetail(List<ScpDemandOrderDRpcDTO> rpcDTOS) {
        log.info("【updateDemandOrderDetail】更新订货单明细：{}", JSONUtil.toJsonStr(rpcDTOS));
        for (ScpDemandOrderDRpcDTO rpcDTO : rpcDTOS) {
            scpDemandOrderDDomainService.saveDemandOrderD(ScpDemandOrderDConvert.INSTANCE.rpcDtoToSaveVO(rpcDTO));
        }
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> updateAllocationQuantity(List<ScpDemandOrderDRpcAllocDTO> rpcDTOS) {
        log.info("【updateDemandOrderDetail】更新订货单配货数量：{}", JSONUtil.toJsonStr(rpcDTOS));
        for (ScpDemandOrderDRpcAllocDTO rpcDTO : rpcDTOS) {
            scpDemandOrderDDomainService.updateAllocQuantity(rpcDTO.getId(), rpcDTO.getAllocationQuantity());
        }

        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> updateQuantity(List<ScpDemandOrderDRpcQuantityDTO> rpcDTOS) {
        log.info("【updateDemandOrderDetail】更新订货单发货数量：{}", JSONUtil.toJsonStr(rpcDTOS));
        for (ScpDemandOrderDRpcQuantityDTO rpcDTO : rpcDTOS) {
            scpDemandOrderDDomainService.updateQuantity(rpcDTO.getId(), rpcDTO.getQuantity());
        }
        List<Long> ids = rpcDTOS.stream().map(ScpDemandOrderDRpcQuantityDTO::getId).collect(Collectors.toList());
        List<Long> masIds = scpDemandOrderDDomainService.getMasIdByDId(ids).stream().distinct().collect(Collectors.toList());
        for (Long masId : masIds) {
            scpDemandOrderDomainService.updateDocStatusById(masId, ScpConstant.DELIVERY);
        }
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> updateRecvQty(List<ScpDemandOrderDRpcRecvQtyDTO> rpcDTOS) {
        log.info("【updateDemandOrderDetail】更新订货单收货数量：{}", JSONUtil.toJsonStr(rpcDTOS));
        for (ScpDemandOrderDRpcRecvQtyDTO rpcDTO : rpcDTOS) {
            scpDemandOrderDDomainService.updateRecvQty(rpcDTO.getId(), rpcDTO.getRecvQty());
        }
        List<Long> ids = rpcDTOS.stream().map(ScpDemandOrderDRpcRecvQtyDTO::getId).collect(Collectors.toList());
        List<Long> masIds = scpDemandOrderDDomainService.getMasIdByDId(ids).stream().distinct().collect(Collectors.toList());
        for (Long masId : masIds) {
            scpDemandOrderDomainService.updateDocStatusById(masId, ScpConstant.RECV);
        }
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> cancelOrder(ScpDemandOrderCancelDTO cancelDTO) {
        log.info("【cancelOrder】订货单取消：{}", JSONUtil.toJsonStr(cancelDTO));
        if (CollUtil.isEmpty(cancelDTO.getDIds())) {
            return ApiResult.ok();
        }
        scpDemandOrderDDomainService.cancelOrderByDIds(cancelDTO.getDIds());
        scpDemandOrderDomainService.updateDocStatusById(cancelDTO.getId(), ScpConstant.CANCEL);
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> payCallback(ScpDemandOrderCancelDTO cancelDTO) {
        log.info("【payCallback】订货单支付回传：{}", JSONUtil.toJsonStr(cancelDTO));
        scpDemandOrderDDomainService.updatePayStatus(cancelDTO.getDIds(), ScpUdcEnum.PAY_STATUS_PAYED.getValueCode());
        scpDemandOrderDomainService.updatePayStatusById(cancelDTO.getId());
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Long> checkUnRecvOrder(ScpOrderUnRecvParamVO paramVO) {
        StoreReceivePageParam storeReceivePageParam = new StoreReceivePageParam();
        storeReceivePageParam.setStatusList(List.of("CE"));
        storeReceivePageParam.setRtType("R");
        storeReceivePageParam.setStoreIds(List.of(paramVO.getStoreId()));
        storeReceivePageParam.setCreateDateTo(paramVO.getDateTime());
        return ApiResult.ok(storeReceiveService.countStoreReceive(storeReceivePageParam));
    }
}
