/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderImportEntity;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderImportSaveVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderItemBatchParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDMgmtSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSaveVO;
import com.elitesland.scp.application.service.order.ScpDemandOrderDService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.domain.service.order.ScpDemandSetDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandSetDTO;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.scp.utils.ValidatedList;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class ScpDemandOrderImportService
implements DataImport<ScpDemandOrderImportEntity> {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderImportService.class);
    private static final String LINE = "\n";
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u6821\u9a8c\u5f02\u5e38: {2}; ";
    private final TransactionTemplate transactionTemplate;
    private final ScpDemandOrderService scpDemandOrderService;
    private final ScpDemandOrderDService scpDemandOrderDService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ScpDemandSetDomainService scpDemandSetDomainService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final RmiItemService rmiItemService;
    private final UdcProvider sysUdcService;

    public Set<Integer> sheetNoList() {
        return Collections.singleton(1);
    }

    public Integer stepSize() {
        return 1000000;
    }

    public String getTmplCode() {
        return "yst_scp_demand_order_import";
    }

    public List<String> executeImport(List<ScpDemandOrderImportEntity> dataList, int startRowIndex) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        try {
            List<String> errorMsg = this.checkAndSaveData(dataList, startRowIndex);
            if (errorMsg != null) {
                log.info("\u8ba2\u8d27\u5355\u5bfc\u5165\u5b8c\u6210,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b:{}", (Object)JSONUtil.toJsonStr(errorMsg));
            } else {
                log.info("\u8ba2\u8d27\u5355\u5bfc\u5165\u5b8c\u6210,\u672a\u53d1\u751f\u9519\u8bef");
            }
            return errorMsg;
        }
        catch (Exception e) {
            for (ScpDemandOrderImportEntity entity : dataList) {
                errors.add(e.getMessage());
            }
            return errors;
        }
    }

    private List<String> checkAndSaveData(List<ScpDemandOrderImportEntity> dataList, int startRowIndex) {
        LinkedHashMap<Integer, String> errMsgMap = new LinkedHashMap<Integer, String>();
        Integer index = 0;
        for (ScpDemandOrderImportEntity entity : dataList) {
            entity.setRowNo(index);
            errMsgMap.put(index, null);
            Integer n = index;
            index = index + 1;
        }
        log.info("startRowIndex\u7684\u503c:{}", (Object)startRowIndex);
        HashSet<String> errorDocNumSet = new HashSet<String>();
        List<ScpDemandOrderImportSaveVO> dataToSave = this.prepareData(dataList, errMsgMap, errorDocNumSet);
        log.info("\u8ba2\u8d27\u5355\u5bfc\u5165\uff0c\u51c6\u5907\u597d\u7684\u6570\u636e:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr(dataToSave), (Object)JSONUtil.toJsonStr(errMsgMap));
        this.transactionTemplate.setPropagationBehavior(3);
        for (ScpDemandOrderImportSaveVO vo : dataToSave) {
            this.transactionTemplate.execute(transactionStatus -> {
                try {
                    Long masId = this.scpDemandOrderService.saveDemandOrder(vo.getHeaderSaveVO());
                    this.scpDemandOrderDService.batchSaveDemandOrderDMgmt(masId, vo.getDetailSaveVOs());
                }
                catch (Exception e) {
                    log.error("\u8ba2\u8d27\u5355\u5bfc\u5165\u62a5\u9519\uff1a" + e);
                    transactionStatus.setRollbackOnly();
                }
                return null;
            });
        }
        long docNumber = dataList.stream().map(ScpDemandOrderImportEntity::getSeqNo).distinct().count();
        String orderMsg = String.format("\u6587\u4ef6\u5171\u5305\u542b%d\u6761\u6570\u636e\uff0c\u8bc6\u522b\u51fa\u8ba2\u8d27\u5355%d\u5355\uff0c\u5176\u4e2d\u5bfc\u5165\u6210\u529f%d\u5355\uff0c\u5931\u8d25%d\u5355", dataList.size(), docNumber, docNumber - (long)errorDocNumSet.size(), errorDocNumSet.size());
        log.info("\u5199\u5165\u81ea\u5b9a\u4e49\u63d0\u793a\u8bed:{}", (Object)orderMsg);
        HttpServletUtil.currentRequest().setAttribute("orderMsg", (Object)orderMsg);
        return new ArrayList<String>(errMsgMap.values());
    }

    private List<ScpDemandOrderImportSaveVO> prepareData(List<ScpDemandOrderImportEntity> dataList, Map<Integer, String> errMsgMap, Set<String> errorDocNumSet) {
        ArrayList<ScpDemandOrderImportSaveVO> resultList = new ArrayList<ScpDemandOrderImportSaveVO>();
        Map<String, List<ScpDemandOrderImportEntity>> seqNoMap = dataList.stream().collect(Collectors.groupingBy(ScpDemandOrderImportEntity::getSeqNo));
        List<String> demandSetNameList = dataList.stream().collect(Collectors.groupingBy(ScpDemandOrderImportEntity::getDemandSetName)).keySet().stream().distinct().collect(Collectors.toList());
        ScpDemandSetParamVO paramVO = ScpDemandSetParamVO.builder().demandNames(demandSetNameList).expireTime(LocalDateTime.now()).build();
        List<ScpDemandSetDTO> scpDemandSetDTOList = this.scpDemandSetDomainService.findDemandSetByParam(paramVO);
        if (CollUtil.isEmpty(scpDemandSetDTOList)) {
            ScpDemandOrderImportService.addErrMsg(errMsgMap, dataList.stream().map(ScpDemandOrderImportEntity::getRowNo).collect(Collectors.toList()), "\u8ba2\u8d27\u96c6\u4e0d\u5b58\u5728");
            errorDocNumSet.addAll(dataList.stream().map(ScpDemandOrderImportEntity::getSeqNo).collect(Collectors.toList()));
            return null;
        }
        Map uomMap = this.sysUdcService.getValueMapByUdcCode("yst-supp", "UOM");
        List<ScpOrderSettingRespVO> enabledSetting = this.scpOrderSettingDomainService.findEnabledSetting();
        Map settingMap = enabledSetting.stream().collect(Collectors.toMap(row -> row.getDocTypeName() + "@" + row.getType(), Function.identity()));
        Map scpDemandSetDTOMap = scpDemandSetDTOList.stream().collect(Collectors.toMap(ScpDemandSetDTO::getDemandName, Function.identity()));
        for (Map.Entry<String, List<ScpDemandOrderImportEntity>> entry : seqNoMap.entrySet()) {
            ScpDemandOrderImportSaveVO scpDemandOrderImportSaveVO = new ScpDemandOrderImportSaveVO();
            ScpDemandOrderSaveVO result = new ScpDemandOrderSaveVO();
            List<ScpDemandOrderImportEntity> itemList = entry.getValue();
            ScpDemandOrderImportEntity header = itemList.get(0);
            List<Integer> rowNoList = itemList.stream().map(ScpDemandOrderImportEntity::getRowNo).collect(Collectors.toList());
            ScpDemandSetDTO scpDemandSetDTO = (ScpDemandSetDTO)scpDemandSetDTOMap.get(header.getDemandSetName());
            if (scpDemandSetDTO == null) {
                ScpDemandOrderImportService.addErrMsg(errMsgMap, rowNoList, "\u8ba2\u8d27\u96c6:" + header.getDemandSetName() + "\u4e0d\u5b58\u5728");
                errorDocNumSet.add(entry.getKey());
                continue;
            }
            result.setDemandId(scpDemandSetDTO.getId());
            result.setDemandCode(scpDemandSetDTO.getDemandCode());
            result.setDemandName(scpDemandSetDTO.getDemandName());
            result.setDemandDate(scpDemandSetDTO.getDemandDate());
            result.setType(scpDemandSetDTO.getType());
            result.setDemandWhStCode(header.getDemandWhStCode());
            result.setDemandWhStName(header.getDemandWhStName());
            String docCls = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(scpDemandSetDTO.getType()) ? ScpUdcEnum.OB_DOC_CLS_ST.getValueCode() : ScpUdcEnum.OB_DOC_CLS_WH.getValueCode();
            result.setDocCls(docCls);
            ScpOrderSettingRespVO scpOrderSettingRespVO = (ScpOrderSettingRespVO)settingMap.get(header.getDocTypeName() + "@" + result.getType());
            if (scpOrderSettingRespVO == null) {
                ScpDemandOrderImportService.addErrMsg(errMsgMap, rowNoList, "\u5355\u636e\u7c7b\u578b:" + header.getDocTypeName() + "\u4e0d\u5b58\u5728");
                errorDocNumSet.add(entry.getKey());
                continue;
            }
            result.setDocType(scpOrderSettingRespVO.getDocType());
            if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(result.getType())) {
                List<OrgStoreBaseRpcDTO> orgStores = this.rmiOrgStoreRpcService.findOrgStoreBaseByParam(List.of(result.getDemandWhStCode()));
                if (CollUtil.isEmpty(orgStores)) {
                    ScpDemandOrderImportService.addErrMsg(errMsgMap, rowNoList, "\u95e8\u5e97\u7f16\u7801:" + result.getDemandWhStCode() + "\u4e0d\u5b58\u5728");
                    errorDocNumSet.add(entry.getKey());
                    continue;
                }
                OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = orgStores.get(0);
                result.setDemandWhStId(orgStoreBaseRpcDTO.getId());
                result.setDemandWhStName(orgStoreBaseRpcDTO.getStoreName());
                result.setStoreLevel(orgStoreBaseRpcDTO.getStoreLevel());
                result.setStoreType2(orgStoreBaseRpcDTO.getStoreType2());
                result.setOuCode(orgStoreBaseRpcDTO.getOuCode());
                result.setBrandCode(orgStoreBaseRpcDTO.getBrandCode());
            } else {
                InvWhRpcSimpleDTO whRpcSimpleDTO = this.rmiInvStkRpcService.findSimpleWhByCode(result.getDemandWhStCode());
                if (whRpcSimpleDTO == null) {
                    ScpDemandOrderImportService.addErrMsg(errMsgMap, rowNoList, "\u4ed3\u5e93\u7f16\u7801:" + result.getDemandWhStCode() + "\u4e0d\u5b58\u5728");
                    errorDocNumSet.add(entry.getKey());
                    continue;
                }
                result.setDemandWhStId(whRpcSimpleDTO.getWhId());
                result.setDemandWhStName(whRpcSimpleDTO.getWhName());
                result.setOuCode(whRpcSimpleDTO.getOuCode());
            }
            scpDemandOrderImportSaveVO.setHeaderSaveVO(result);
            ScpDemandOrderItemBatchParamVO scpDemandOrderItemBatchParamVO = new ScpDemandOrderItemBatchParamVO();
            scpDemandOrderItemBatchParamVO.setDemandDate(result.getDemandDate());
            scpDemandOrderItemBatchParamVO.setDemandWhStCode(result.getDemandWhStCode());
            scpDemandOrderItemBatchParamVO.setType(result.getType());
            scpDemandOrderItemBatchParamVO.setDocType(result.getDocType());
            List<String> itemCodes = itemList.stream().map(ScpDemandOrderImportEntity::getItemCode).distinct().collect(Collectors.toList());
            List<ItmItemBusinessRpcDTO> itmItemBusinessList = this.rmiItemService.findItmItemBusinessByBUCodeAndBrandAndItemList(result.getOuCode(), result.getBrandCode(), itemCodes);
            Map<String, List<ItmItemBusinessRpcDTO>> itemMap = itmItemBusinessList.stream().collect(Collectors.groupingBy(ItmItemBusinessRpcDTO::getItemCode));
            ArrayList<ScpDemandOrderItemBatchParamVO.Item> batchParamList = new ArrayList<ScpDemandOrderItemBatchParamVO.Item>();
            AtomicBoolean isValid = new AtomicBoolean(true);
            itemList.forEach(row -> {
                List businessItems = (List)itemMap.get(row.getItemCode());
                if (CollUtil.isEmpty((Collection)businessItems)) {
                    ScpDemandOrderImportService.addErrMsg(errMsgMap, row.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u5546\u54c1", "\u5546\u54c1\u7f16\u7801:" + row.getItemCode() + "\u5173\u8054\u7ecf\u8425\u76ee\u5f55\u4e0d\u5b58\u5728"));
                    isValid.getAndSet(false);
                    return;
                }
                ItmItemBusinessRpcDTO businessItem = (ItmItemBusinessRpcDTO)businessItems.get(0);
                ScpDemandOrderItemBatchParamVO.Item item = new ScpDemandOrderItemBatchParamVO.Item();
                item.setItemId(businessItem.getId());
                item.setItemCode(businessItem.getItemCode());
                item.setItemName(businessItem.getItemName());
                item.setItemCateCode(businessItem.getItemCateCode());
                item.setSpuId(businessItem.getSpuId());
                item.setSpuItemCode(businessItem.getSpuCode());
                item.setSpuItemName(businessItem.getSpuName());
                item.setUom(businessItem.getUom2());
                item.setUomName((String)uomMap.get(businessItem.getUom2()));
                item.setDemandQuantity(row.getDemandQuantity());
                item.setQty2(SysUtils.processQtyScale(row.getDemandQuantity().multiply(businessItem.getUomRatio2())));
                item.setUom2(businessItem.getUom());
                item.setUom2Name((String)uomMap.get(businessItem.getUom()));
                item.setDecimalPlaces(businessItem.getDecimalPlaces());
                item.setUomRatio(businessItem.getUomRatio2());
                item.setItemType(businessItem.getItemType2());
                batchParamList.add(item);
            });
            if (!isValid.get()) {
                errorDocNumSet.add(entry.getKey());
                continue;
            }
            scpDemandOrderItemBatchParamVO.setItemList(batchParamList);
            Map<String, List<ScpDemandOrderDRespVO>> itemListBatchMap = this.scpDemandOrderService.getItemListBatch(scpDemandOrderItemBatchParamVO);
            for (ScpDemandOrderImportEntity entity : itemList) {
                List<ScpDemandOrderDRespVO> orderDRespVOS = itemListBatchMap.get(entity.getItemCode());
                if (CollUtil.isEmpty(orderDRespVOS)) {
                    ScpDemandOrderImportService.addErrMsg(errMsgMap, entity.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u5546\u54c1\u4f9b\u8d27\u5173\u7cfb", "\u5546\u54c1\u4f9b\u8d27\u5173\u7cfb\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4"));
                    isValid.getAndSet(false);
                    break;
                }
                orderDRespVOS.forEach(row -> {
                    String ouCode = row.getOuCode();
                    if (StrUtil.isBlank((CharSequence)ouCode)) {
                        return;
                    }
                    if (row.getPrice() == null) {
                        ScpDemandOrderImportService.addErrMsg(errMsgMap, entity.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u4ef7\u683c", "\u5546\u54c1\u7f16\u7801\u3010" + row.getItemCode() + "\u3011,\u516c\u53f8\u7f16\u7801\u3010" + ouCode + "\u3011\u672a\u914d\u7f6e\u7ed3\u7b97\u4ef7\u683c\u4fe1\u606f"));
                        isValid.getAndSet(false);
                    }
                });
            }
            if (!isValid.get()) {
                errorDocNumSet.add(entry.getKey());
                continue;
            }
            ArrayList<ScpDemandOrderDMgmtSaveVO> mgmtSaveVOS = new ArrayList<ScpDemandOrderDMgmtSaveVO>();
            itemListBatchMap.forEach((key, value) -> {
                ScpDemandOrderDRespVO scpDemandOrderDRespVO = (ScpDemandOrderDRespVO)value.get(0);
                ScpDemandOrderDMgmtSaveVO saveVO = new ScpDemandOrderDMgmtSaveVO();
                saveVO.setSpuItemName(scpDemandOrderDRespVO.getSpuItemName());
                saveVO.setSpuItemCode(scpDemandOrderDRespVO.getSpuItemCode());
                saveVO.setItemId(scpDemandOrderDRespVO.getItemId());
                saveVO.setItemCode(scpDemandOrderDRespVO.getItemCode());
                saveVO.setItemName(scpDemandOrderDRespVO.getItemName());
                saveVO.setItemType(scpDemandOrderDRespVO.getItemType());
                saveVO.setDemandQuantity(scpDemandOrderDRespVO.getDemandQuantity());
                saveVO.setCurrency("CNY");
                ValidatedList supplyItemList = value.stream().map(row -> {
                    ScpDemandOrderDMgmtSaveVO.SupplyItem supplyItem = new ScpDemandOrderDMgmtSaveVO.SupplyItem();
                    supplyItem.setRatio(row.getRatio());
                    supplyItem.setAllocationDeQuantity(row.getAllocationDeQuantity());
                    supplyItem.setAllocationQuantity(row.getAllocationQuantity());
                    supplyItem.setSupplyType(row.getSupplyType());
                    supplyItem.setSuppWhId(row.getSuppWhId());
                    supplyItem.setSuppWhCode(row.getSuppWhCode());
                    supplyItem.setSuppWhName(row.getSuppWhName());
                    supplyItem.setOuId(row.getOuId());
                    supplyItem.setOuCode(row.getOuCode());
                    supplyItem.setOuName(row.getOuName());
                    supplyItem.setIsCalculated(Boolean.FALSE);
                    supplyItem.setIsPushed(Boolean.FALSE);
                    supplyItem.setUnit(row.getUnit());
                    supplyItem.setUnitName(row.getUnitName());
                    supplyItem.setUom2(row.getUom2());
                    supplyItem.setUom2Name(row.getUom2Name());
                    supplyItem.setUomRatio(row.getUomRatio());
                    supplyItem.setDecimalPlaces(row.getDecimalPlaces());
                    supplyItem.setQty2(row.getQty2());
                    supplyItem.setPrice(row.getPrice());
                    supplyItem.setFreightFlag(row.getFreightFlag());
                    supplyItem.setFreightRatio(row.getFreightRatio());
                    supplyItem.setSaleCustCode(row.getSaleCustCode());
                    supplyItem.setSaleOuName(row.getSaleOuName());
                    supplyItem.setSaleOuCode(row.getSaleOuCode());
                    supplyItem.setAllocationQuantity(row.getAllocationQuantity());
                    return supplyItem;
                }).collect(Collectors.toCollection(ValidatedList::new));
                saveVO.setItemList(supplyItemList);
                mgmtSaveVOS.add(saveVO);
            });
            scpDemandOrderImportSaveVO.setDetailSaveVOs(mgmtSaveVOS);
            resultList.add(scpDemandOrderImportSaveVO);
        }
        return resultList;
    }

    public static void addErrMsg(Map<Integer, String> errMsgMap, Integer rowNo, String msg) {
        ScpDemandOrderImportService.addErrMsg(errMsgMap, Collections.singletonList(rowNo), msg);
    }

    public static void addErrMsg(Map<Integer, String> errMsgMap, List<Integer> rowNos, String msg) {
        for (Integer rowNo : rowNos) {
            if (errMsgMap.containsKey(rowNo) && errMsgMap.get(rowNo) != null) {
                String newMsg = errMsgMap.get(rowNo) + LINE + msg;
                errMsgMap.put(rowNo, newMsg);
                continue;
            }
            errMsgMap.put(rowNo, msg);
        }
    }

    public ScpDemandOrderImportService(TransactionTemplate transactionTemplate, ScpDemandOrderService scpDemandOrderService, ScpDemandOrderDService scpDemandOrderDService, ScpOrderSettingDomainService scpOrderSettingDomainService, ScpDemandSetDomainService scpDemandSetDomainService, RmiOrgStoreRpcService rmiOrgStoreRpcService, RmiInvStkRpcService rmiInvStkRpcService, RmiItemService rmiItemService, UdcProvider sysUdcService) {
        this.transactionTemplate = transactionTemplate;
        this.scpDemandOrderService = scpDemandOrderService;
        this.scpDemandOrderDService = scpDemandOrderDService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
        this.scpDemandSetDomainService = scpDemandSetDomainService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.rmiItemService = rmiItemService;
        this.sysUdcService = sysUdcService;
    }
}

