/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.order;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.param.account.AccountAppRpcParam;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderItemBatchParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderItemParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderPayInfoRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderTitlePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpPayOrderPageRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSaveVO;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8ba2\u8d27\u8ba2\u5355\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/order"}, produces={"application/json"})
public class ScpDemandOrderController {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderController.class);
    private final ScpDemandOrderService scpDemandOrderService;

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<ScpDemandOrderTitlePageRespVO>> page(@RequestBody ScpDemandOrderPageParamVO paramVO) {
        log.info("[SCP-DEMAND-ORDER] page  param ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.scpDemandOrderService.page(paramVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u8ba2\u8d27\u5355\u660e\u7ec6\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/detail/page"})
    public ApiResult<PagingVO<ScpDemandOrderPageRespVO>> queryDemandOrderList(@RequestBody ScpDemandOrderPageParamVO paramVO) {
        log.info("[SCP-DEMAND-ORDER] queryDemandOrderList  param ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.scpDemandOrderService.queryDemandOrderPage(paramVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u8ba2\u8d27\u8ba2\u5355\u8be6\u60c5\u4fe1\u606f")
    @GetMapping(value={"/findIdOne/{id}"})
    public ApiResult<ScpDemandOrderRespVO> findIdOne(@PathVariable Long id) {
        log.info("[SCP-DEMAND-ORDER] findIdOne, id ={}", (Object)id);
        return this.scpDemandOrderService.findDemandOrderCateById(id).map(ApiResult::ok).orElse(ApiResult.fail((ApiCode)ApiCode.NOT_FOUND));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355\u8868\u5934 - \u4fdd\u5b58")
    public ApiResult<Long> saveDemandOrder(@RequestBody @Validated ScpDemandOrderSaveVO saveVO) {
        log.info("[SCP-DEMAND-SET] saveDemandOrder  saveVO ={}", (Object)JSONUtil.toJsonStr((Object)saveVO));
        return ApiResult.ok((Object)this.scpDemandOrderService.saveDemandOrder(saveVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u83b7\u53d6\u5546\u54c1\u660e\u7ec6\u884c\u4fe1\u606f")
    @PostMapping(value={"/item/list"})
    public ApiResult<List<ScpDemandOrderDRespVO>> getItemList(@RequestBody @Validated ScpDemandOrderItemParamVO paramVO) {
        log.info("[SCP-DEMAND-ORDER] getItemList  param ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        return ApiResult.ok(this.scpDemandOrderService.getItemList(paramVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u6279\u91cf\u83b7\u53d6\u5546\u54c1\u660e\u7ec6\u884c\u4fe1\u606f")
    @PostMapping(value={"/item/list/batch"})
    public ApiResult<Map<String, List<ScpDemandOrderDRespVO>>> getItemListBatch(@RequestBody @Validated ScpDemandOrderItemBatchParamVO paramVO) {
        log.info("[SCP-DEMAND-ORDER] getItemListBatch  param ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        return ApiResult.ok(this.scpDemandOrderService.getItemListBatch(paramVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u53d6\u6d88")
    @PostMapping(value={"/cancel/{id}"})
    public ApiResult<Object> getItemList(@PathVariable Long id) {
        log.info("[SCP-DEMAND-ORDER] getItemList  param ={}", (Object)id);
        this.scpDemandOrderService.cancelScpDemand(id);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u5355 - \u63a8\u9001")
    @PostMapping(value={"/push/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u8ba2\u8d27\u5355\u63a8\u9001", allowRepeatRequest=false)
    public ApiResult<Object> push(@PathVariable Long id) {
        log.info("[SCP-DEMAND-ORDER] push id = {}", (Object)JSONUtil.toJsonStr((Object)id));
        this.scpDemandOrderService.push(id);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u652f\u4ed8\u5f39\u7a97")
    @PostMapping(value={"/pay/{id}"})
    public ApiResult<List<ScpDemandOrderPayInfoRespVO>> payInfo(@PathVariable Long id) {
        log.info("[SCP-DEMAND-ORDER] payInfo  param ={}", (Object)id);
        return ApiResult.ok(this.scpDemandOrderService.payInfo(id));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u5f85\u4ed8\u6b3e\u5217\u8868")
    @PostMapping(value={"/pay/page"})
    public ApiResult<PagingVO<ScpPayOrderPageRespVO>> payPage(@RequestBody ScpDemandOrderPageParamVO paramVO) {
        log.info("[SCP-DEMAND-ORDER] page  param ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.scpDemandOrderService.payPage(paramVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u5173\u95ed")
    @PostMapping(value={"/close/{id}"})
    public ApiResult<List<ScpDemandOrderPayInfoRespVO>> close(@PathVariable Long id) {
        log.info("[SCP-DEMAND-ORDER] close  param ={}", (Object)id);
        this.scpDemandOrderService.close(id);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u5b50\u8ba2\u5355 - \u5173\u95ed")
    @PostMapping(value={"/close/{id}/{type}"})
    public ApiResult<List<ScpDemandOrderPayInfoRespVO>> close(@PathVariable Long id, @PathVariable String type) {
        log.info("[SCP-DEMAND-ORDER] close  param ={}", (Object)id);
        this.scpDemandOrderService.closePoOrTro(id, type);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u83b7\u53d6\u5f3a\u914d\u5546\u54c1\u4fe1\u606f")
    @PostMapping(value={"/alloc"})
    public ApiResult<Map<String, List<ScpDemandOrderDRespVO>>> findEnableAllocSetting(@RequestBody @Validated ScpAllocSettingParamVO paramVO) {
        log.info("[SCP-DEMAND-ORDER] findEnableAllocSetting paramVO = {}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        return ApiResult.ok(this.scpDemandOrderService.findEnableAllocSetting(paramVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u8ba2\u8d27\u8ba2\u5355\u5206\u9875\u67e5\u8be2-\u8fd4\u56de\u8d26\u6237\u6d41\u6c34\u5206\u7ec4\u6570\u636e")
    @PostMapping(value={"/pageWithAccountFlow"})
    public ApiResult<PagingVO<ScpDemandOrderTitlePageRespVO>> pageWithAccountFlow(@RequestBody AccountAppRpcParam paramVO) {
        log.info("[SCP-DEMAND-ORDER] page  param ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        return ApiResult.ok(this.scpDemandOrderService.pageWithAccountFlow(paramVO));
    }

    public ScpDemandOrderController(ScpDemandOrderService scpDemandOrderService) {
        this.scpDemandOrderService = scpDemandOrderService;
    }
}

