package com.elitesland.scp.application.facade.vo.template;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @Auther: Mark
 * @Date: 2024/4/29 09:34
 * @Description:
 */
@Data
@ApiModel(description = "选择模板列表")
public class DemandOrderListParamVO {

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不允许为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "类型，0:门店，1:仓库", required = true)
    @NotBlank(message = "订货单类型不允许为空")
    private String type;

    @ApiModelProperty(value = "单据类型", required = true)
    private String docType;

    @ApiModelProperty("订货模板搜索条件")
    private String demandTemSearchWord;
}
