package com.elitesland.scp.application.service.export;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightExportRespVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightPageParamVO;
import com.elitesland.scp.application.service.freight.ScpStoreOrderFreightService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
@RequiredArgsConstructor
public class ScpStoreOrderFreightServiceExportImpl implements DataExport<ScpStoreOrderFreightExportRespVO, ScpStoreOrderFreightPageParamVO>{
    private final ScpStoreOrderFreightService scpStoreOrderFreightService;

    @Override
    public String getTmplCode() {
        return "scp_store_order_freight_export";
    }

    @Override
    public PagingVO<ScpStoreOrderFreightExportRespVO> executeExport(ScpStoreOrderFreightPageParamVO queryParam) {
        return scpStoreOrderFreightService.exportSearch(queryParam);
    }
}
