package com.elitesland.scp.application.web.calendar;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLinePageParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLinePageRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetLineDelVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetLineSaveVO;
import com.elitesland.scp.application.service.calendar.ScpStoreCalendarSetLineService;
import com.elitesland.scp.utils.ValidatedList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@Api(tags = "门店订货日历配置明细接口")
@RestController
@RequestMapping(value = "/calendar/setting/line", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpStoreCalendarSetLineController {

    private final ScpStoreCalendarSetLineService scpStoreCalendarSetLineService;

    @ApiOperation(value = "门店订货日历配置明细-  分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpStoreCalendarSetLinePageRespVO>> queryCalendarSetLine(@RequestBody ScpStoreCalendarSetLinePageParamVO paramVO) {
        log.info("[SCP-STORE-CALENDAR-SET-LINE] queryCalendarSetLine  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpStoreCalendarSetLineService.page(paramVO));
    }

    @PostMapping("/save")
    @ApiOperation("门店订货日历配置明细 - 保存")
    public ApiResult<Long> saveCalendarSetLine(@RequestParam("masId") Long masId, @RequestBody @Validated ValidatedList<ScpStoreCalendarSetLineSaveVO> saveVOS) {
        log.info("[SCP-STORE-CALENDAR-SET-LINE] saveCalendarSetLine  saveVO ={}", JSONUtil.toJsonStr(saveVOS));
        scpStoreCalendarSetLineService.saveCalendarSetLine(masId, saveVOS);
        return ApiResult.ok();
    }

    @ApiOperation("门店订货日历配置明细 - 删除")
    @PostMapping("/delete")
    public ApiResult<Object> delete(@RequestBody ScpStoreCalendarSetLineDelVO paramVO) {
        log.info("[SCP-STORE-CALENDAR-SET-LINE] delete paramVO = {}", JSONUtil.toJsonStr(paramVO));
        scpStoreCalendarSetLineService.deleteByParam(paramVO);
        return ApiResult.ok();
    }

}
