package com.elitesland.scp.application.service.item;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemHotParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemParam;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemParam.CateItem;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemRespVO;
import com.elitesland.scp.domain.entity.item.ScpCateItemDO;
import com.elitesland.scp.domain.service.item.ScpCateItemDomainService;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.param.CateItemRpcParam;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemCateRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSimpleRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.service.ItmItemCateRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description: TODO
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2024/4/3 11:42 上午
 * @version:v1.0
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ScpCateItemServiceImpl implements ScpCateItemService {

    private final ScpCateItemDomainService scpCateItemDomainService;
    private final RmiItemService rmiItemService;
    private final ItmItemCateRpcService itmItemCateRpcService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void bindItem(ScpCateItemParam cateStoreParam) {
        Map<Long, List<String>> rootBrandMap = rmiItemService.findRootBrandByCateId(cateStoreParam.getCateId());
        List<String> brands = rootBrandMap.values().stream().findAny().get();
        if (CollUtil.isEmpty(brands)) {
            throw new BusinessException("品类下无品牌信息");
        }
        Long rootId = rootBrandMap.keySet().stream().findAny().get();
        String brand = String.join(";", brands);
        List<CateItem> items = cateStoreParam.getItems();
        List<Long> itemIds = items.stream().map(CateItem::getItemId).distinct().collect(Collectors.toList());
        ItmItemBaseRpcParam rpcParam = new ItmItemBaseRpcParam();
        rpcParam.setItemIds(itemIds);
        Map<Long, ItmItemBaseRpcDTO> itmMap = rmiItemService.findItemBaseRpcDtoByParam(rpcParam).stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getId, Function.identity()));
        scpCateItemDomainService.saveBatch(items.stream().map(item -> {
            ScpCateItemDO scpCateItemDO = BeanUtils.toBean(item, ScpCateItemDO.class);
            if (ObjectUtils.isNotEmpty(item.getItemId()) && MapUtils.isNotEmpty(itmMap)) {
                ItmItemBaseRpcDTO itmItemRpcDTO = itmMap.get(item.getItemId());
                scpCateItemDO.setSpuId(itmItemRpcDTO.getSpuId());
                scpCateItemDO.setSpuCode(itmItemRpcDTO.getSpuCode());
                scpCateItemDO.setSpuName(itmItemRpcDTO.getSpuName());
                scpCateItemDO.setItemType(itmItemRpcDTO.getItemType());
                scpCateItemDO.setAnotherName(itmItemRpcDTO.getAnotherName());
                scpCateItemDO.setItemType2(itmItemRpcDTO.getItemType2());
                scpCateItemDO.setCombineItemFlag(ScpUdcEnum.ITM_ITM_TYPE_70.getValueCode().equals(itmItemRpcDTO.getItemType()));
            }
            scpCateItemDO.setCateCode(cateStoreParam.getCateCode());
            scpCateItemDO.setCateId(cateStoreParam.getCateId());
            scpCateItemDO.setBrand(brand);
            scpCateItemDO.setRootCateId(rootId);
            return scpCateItemDO;
        }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void remove(List<Long> ids) {
        scpCateItemDomainService.delete(ids);
    }

    @Override
    public ApiResult<List<ScpCateItemDTO>> query(CateItemRpcParam cateItemRpcParam) {
        return scpCateItemDomainService.query(cateItemRpcParam);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void changeHotFlag(ScpCateItemHotParamVO paramVO) {
        scpCateItemDomainService.changeHotFlag(paramVO);
    }

    @Override
    public PagingVO<ScpCateItemRespVO> page(ScpCateItemPageParamVO paramVO) {
        return scpCateItemDomainService.page(paramVO);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpCateItemPageVO> skuPage(ScpCateItemPageParamVO paramVO) {
        PagingVO<ScpCateItemPageVO> scpCateItemPage = scpCateItemDomainService.skuPage(paramVO);
        List<Long> itemIds = scpCateItemPage.getRecords().stream().map(ScpCateItemPageVO::getItemId).distinct().collect(Collectors.toList());
        Map<String, String> objectObjectHashMap = new HashMap<>();
        List<ItmItemCateRpcDTO> syncItemCate = itmItemCateRpcService.findSyncItemCate();
        if(CollectionUtils.isNotEmpty(syncItemCate)){
            objectObjectHashMap=syncItemCate.stream().collect(Collectors.toMap(ItmItemCateRpcDTO::getItemCateCode, ItmItemCateRpcDTO::getItemCateName));
        }
        Map<Long, ItmItemSimpleRpcDTO> baseItemMap = rmiItemService.findBaseItemMap(itemIds);
        for (ScpCateItemPageVO record : scpCateItemPage.getRecords()) {
            if(objectObjectHashMap.get(record.getScpCateCode())!=null){
                record.setScpCateName(objectObjectHashMap.get(record.getScpCateCode()));
            }
            ItmItemSimpleRpcDTO itmItemSimpleRpcDTO = baseItemMap.get(record.getItemId());
            if (ObjectUtils.isEmpty(itmItemSimpleRpcDTO)) {
                continue;
            }
            record.setItemName(itmItemSimpleRpcDTO.getItemName());
            record.setSpec(itmItemSimpleRpcDTO.getSpec());
            record.setItemCateFullName(itmItemSimpleRpcDTO.getItemCateFullName());
            record.setBrandName(itmItemSimpleRpcDTO.getBrandName());
            record.setTaxRate(itmItemSimpleRpcDTO.getTaxRate());
            record.setTaxRate2(itmItemSimpleRpcDTO.getTaxRate2());
            record.setItemType(itmItemSimpleRpcDTO.getItemType());
            record.setItemType2(itmItemSimpleRpcDTO.getItemType2());
            record.setItemSupplySource(itmItemSimpleRpcDTO.getItemSupplySource());
            record.setLotFlag(itmItemSimpleRpcDTO.getLotFlag());
            record.setAllocType(itmItemSimpleRpcDTO.getAllocType());
            record.setGuaranteePeriod(itmItemSimpleRpcDTO.getGuaranteePeriod());
            record.setGuaranteePeriodUnit(itmItemSimpleRpcDTO.getGuaranteePeriodUnit());
            record.setSuppCode(itmItemSimpleRpcDTO.getSuppCode());
            record.setSuppName(itmItemSimpleRpcDTO.getSuppName());
        }
        return scpCateItemPage;
    }


    @Override
    public void saveSortNo(Long id, Integer sorNo) {
        scpCateItemDomainService.saveSorNo(id, sorNo);
    }
}
