package com.elitesland.scp.infr.repo.order;

import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface ScpDemandOrderRepo extends JpaRepository<ScpDemandOrderDO, Long>, QuerydslPredicateExecutor<ScpDemandOrderDO> {

    List<ScpDemandOrderDO> findByIdIn(List<Long> ids);

    List<ScpDemandOrderDO> findByDemandIdIn(List<Long> demandIds);

    List<ScpDemandOrderDO> findByDemandId(Long demandId);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "delete from scp_demand_order where id in ?1", nativeQuery = true)
    void deleteByIdIn(List<Long> idList);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order set reply_flag = true, modify_time = CURRENT_TIMESTAMP where id = ?1 and " +
            "delete_flag != 1", nativeQuery = true)
    void updateReplyById(Long id);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order set doc_status = 'CLOSE', modify_time = CURRENT_TIMESTAMP where id = ?1 and " +
            "delete_flag != 1", nativeQuery = true)
    void closeDemandOrder(Long id);

}
