package com.elitesland.scp.application.facade.vo.stock;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 01月 17日 10:40
 * @version: 1.0
 */
@Data
@ExcelIgnoreUnannotated
@ApiModel(value = "ScpPredictStStockDownloadVO", description = "预测安全库存目标库存下载导出")
public class ScpPredictStStockDownloadVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "预测批次ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long stId;

    @ExcelProperty(value = "预测批次ID",index = 0)
    private String stIdStr;

    @ApiModelProperty(value = "公司编码")
    @ExcelProperty(value = "公司编码",index = 1)
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    @ExcelProperty(value = "公司名称", index = 2)
    private String ouName;

    @ApiModelProperty(value = "仓库编码")
    @ExcelProperty(value = "仓库编码",index =3)
    private String whCode;

    @ApiModelProperty(value = "仓库名称")
    @ExcelProperty(value = "仓库名称",index = 4)
    private String whName;

    @ApiModelProperty(value = "商品编码")
    @ExcelProperty(value = "商品编码",index = 5)
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    @ExcelProperty(value = "商品名称",index = 6)
    private String itemName;

    @ApiModelProperty(value = "安全库存")
    @ExcelProperty(value = "安全库存",index = 7)
    private BigDecimal safetyQty;

    @ApiModelProperty(value = "预测安全库存")
    @ExcelProperty(value = "预测安全库存",index = 8)
    private BigDecimal predSafetyQty;

    @ApiModelProperty(value = "目标库存")
    @ExcelProperty(value = "目标库存",index = 9)
    private BigDecimal targetQty;

    @ApiModelProperty(value = "预测目标库存")
    @ExcelProperty(value = "预测目标库存",index = 10)
    private BigDecimal predTargetQty;

    @ApiModelProperty(value = "计划单位")
    @ExcelProperty(value = "计划单位",index = 11)
    private String planUom;

    @ApiModelProperty(value = "计划单位名称")
    @ExcelProperty(value = "计划单位名称",index = 12)
    private String planUomName;

    @ApiModelProperty(value = "基本单位")
    private String uom;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;




}
