package com.elitesland.scp.job.task;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.scp.application.service.app.AppDemandOrderService;
import com.elitesland.scp.job.config.JobConstant;
import com.elitesland.scp.job.service.ScpDemandOrderCloseJobService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class fillFreightHandler {
    @Autowired
    private AppDemandOrderService appDemandOrderService;

    @XxlJob(JobConstant.FILL_FREIGHT_AUTO_CREATE_HANDLER)
    public ReturnT<String> fillFreightHandler(String param) {
        try {
            appDemandOrderService.fillFreightOrder();
        } catch (Exception e) {
            log.error("补充运费定时任务执行失败：", e);
            throw new BusinessException("补充运费定时任务执行失败:" + e.getMessage());
        }
        return ReturnT.SUCCESS;
    }
}
