/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.boh.StoreReceiveCreateSendParam;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StoreReceiveCreateListener
implements MessageQueueListener<StoreReceiveCreateSendParam> {
    private static final Logger log = LoggerFactory.getLogger(StoreReceiveCreateListener.class);
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;

    @NotEmpty
    public String[] channels() {
        return new String[]{"store_order_create"};
    }

    @Transactional(rollbackFor={Exception.class})
    public void onConsume(@NotBlank String s, @NotNull StoreReceiveCreateSendParam storeReceiveSendParam) {
        log.info("\u56de\u5199\u8ba2\u8d27\u5355\u5173\u8054\u7684\u95e8\u5e97\u6536\u8d27\u5355\uff1a" + JSON.toJSONString((Object)storeReceiveSendParam));
        this.updateSrcDocInfo(storeReceiveSendParam);
    }

    private void updateSrcDocInfo(StoreReceiveCreateSendParam storeReceiveSendParam) {
        storeReceiveSendParam.getOrderDocs().forEach(item -> {
            List orderDidList = item.getOrderDidList();
            orderDidList.forEach(row -> this.scpDemandOrderDDomainService.updateSrcInfo(item.getDocId(), item.getDocNo(), row.getOrderDid(), row.getLineNo()));
            this.scpDemandOrderDomainService.updatePushStatusById(item.getOrderId());
        });
    }

    public StoreReceiveCreateListener(ScpDemandOrderDomainService scpDemandOrderDomainService, ScpDemandOrderDDomainService scpDemandOrderDDomainService) {
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
    }
}

